/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.MatchTree;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S1479")
public class TooManyCasesCheck
implements SlangCheck {
    private static final int DEFAULT_MAX = 30;
    @RuleProperty(key="maximum", description="Maximum number of branches", defaultValue="30")
    public int maximum = 30;

    @Override
    public void initialize(InitContext init) {
        init.register(MatchTree.class, (ctx, tree) -> {
            int numberOfCases = tree.cases().size();
            if (numberOfCases > this.maximum) {
                Token matchKeyword = tree.keyword();
                String message2 = String.format("Reduce the number of %s branches from %s to at most %s.", matchKeyword.text(), numberOfCases, this.maximum);
                List<SecondaryLocation> secondaryLocations = tree.cases().stream().map(matchCase -> new SecondaryLocation(matchCase.rangeToHighlight(), null)).collect(Collectors.toList());
                ctx.reportIssue((HasTextRange)matchKeyword, message2, secondaryLocations);
            }
        });
    }
}

