/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.batch.sensor.SensorContext;

class ReportPathsProvider {
    private static final String[] DEFAULT_PATHS = new String[]{"target/site/jacoco/jacoco.xml", "build/reports/jacoco/test/jacocoTestReport.xml"};
    static final String REPORT_PATHS_PROPERTY_KEY = "sonar.coverage.jacoco.xmlReportPaths";
    private final SensorContext context;

    ReportPathsProvider(SensorContext context) {
        this.context = context;
    }

    Collection<Path> getPaths() {
        Set<Path> reportPaths = Stream.of(this.context.config().getStringArray(REPORT_PATHS_PROPERTY_KEY)).map(this::toAbsolutePath).collect(Collectors.toSet());
        if (!reportPaths.isEmpty()) {
            return reportPaths;
        }
        return Arrays.stream(DEFAULT_PATHS).map(this::toAbsolutePath).filter(ReportPathsProvider::reportExists).collect(Collectors.toSet());
    }

    private Path toAbsolutePath(String reportPath) {
        return this.context.fileSystem().baseDir().toPath().resolve(reportPath);
    }

    private static boolean reportExists(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }
}

