/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.es;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.sonar.application.command.EsJvmOptions;
import org.sonar.application.es.EsYmlSettings;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;

public class EsInstallation {
    private final File homeDirectory;
    private final List<File> outdatedSearchDirectories;
    private final File dataDirectory;
    private final File confDirectory;
    private final File logDirectory;
    private EsJvmOptions esJvmOptions;
    private EsYmlSettings esYmlSettings;
    private Properties log4j2Properties;
    private String clusterName;
    private String host;
    private int port;

    public EsInstallation(Props props) {
        File sqHomeDir = props.nonNullValueAsFile(ProcessProperties.Property.PATH_HOME.getKey());
        this.homeDirectory = new File(sqHomeDir, "elasticsearch");
        this.outdatedSearchDirectories = EsInstallation.buildOutdatedSearchDirs(props);
        this.dataDirectory = EsInstallation.buildDataDir(props);
        this.confDirectory = EsInstallation.buildConfDir(props);
        this.logDirectory = EsInstallation.buildLogPath(props);
    }

    private static List<File> buildOutdatedSearchDirs(Props props) {
        String dataPath = props.nonNullValue(ProcessProperties.Property.PATH_DATA.getKey());
        return Arrays.asList(new File(dataPath, "es"), new File(dataPath, "es5"));
    }

    private static File buildDataDir(Props props) {
        String dataPath = props.nonNullValue(ProcessProperties.Property.PATH_DATA.getKey());
        return new File(dataPath, "es6");
    }

    private static File buildLogPath(Props props) {
        return props.nonNullValueAsFile(ProcessProperties.Property.PATH_LOGS.getKey());
    }

    private static File buildConfDir(Props props) {
        File tempPath = props.nonNullValueAsFile(ProcessProperties.Property.PATH_TEMP.getKey());
        return new File(new File(tempPath, "conf"), "es");
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public List<File> getOutdatedSearchDirectories() {
        return Collections.unmodifiableList(this.outdatedSearchDirectories);
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public File getConfDirectory() {
        return this.confDirectory;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public File getExecutable() {
        return new File(this.homeDirectory, "bin/elasticsearch");
    }

    public File getLog4j2PropertiesLocation() {
        return new File(this.confDirectory, "log4j2.properties");
    }

    public File getElasticsearchYml() {
        return new File(this.confDirectory, "elasticsearch.yml");
    }

    public File getJvmOptions() {
        return new File(this.confDirectory, "jvm.options");
    }

    public File getLibDirectory() {
        return new File(this.homeDirectory, "lib");
    }

    public EsJvmOptions getEsJvmOptions() {
        return this.esJvmOptions;
    }

    public EsInstallation setEsJvmOptions(EsJvmOptions esJvmOptions) {
        this.esJvmOptions = esJvmOptions;
        return this;
    }

    public EsYmlSettings getEsYmlSettings() {
        return this.esYmlSettings;
    }

    public EsInstallation setEsYmlSettings(EsYmlSettings esYmlSettings) {
        this.esYmlSettings = esYmlSettings;
        return this;
    }

    public Properties getLog4j2Properties() {
        return this.log4j2Properties;
    }

    public EsInstallation setLog4j2Properties(Properties log4j2Properties) {
        this.log4j2Properties = log4j2Properties;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public EsInstallation setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public EsInstallation setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public EsInstallation setPort(int port) {
        this.port = port;
        return this;
    }
}

