/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.process.ManagedProcess;
import org.sonar.application.process.ManagedProcessEventListener;
import org.sonar.application.process.ManagedProcessLifecycle;
import org.sonar.application.process.ProcessLifecycleListener;
import org.sonar.application.process.StreamGobbler;
import org.sonar.process.ProcessId;

public class ManagedProcessHandler {
    public static final long DEFAULT_WATCHER_DELAY_MS = 500L;
    private static final Logger LOG = LoggerFactory.getLogger(ManagedProcessHandler.class);
    private final ProcessId processId;
    private final ManagedProcessLifecycle lifecycle;
    private final List<ManagedProcessEventListener> eventListeners;
    private final Timeout stopTimeout;
    private final Timeout hardStopTimeout;
    private final long watcherDelayMs;
    private ManagedProcess process;
    private StreamGobbler stdOutGobbler;
    private StreamGobbler stdErrGobbler;
    private final StopWatcher stopWatcher;
    private final EventWatcher eventWatcher;
    private boolean operational = false;

    private ManagedProcessHandler(Builder builder) {
        this.processId = Objects.requireNonNull(builder.processId, "processId can't be null");
        this.lifecycle = new ManagedProcessLifecycle(this.processId, builder.lifecycleListeners);
        this.eventListeners = builder.eventListeners;
        this.stopTimeout = builder.stopTimeout;
        this.hardStopTimeout = builder.hardStopTimeout;
        this.watcherDelayMs = builder.watcherDelayMs;
        this.stopWatcher = new StopWatcher();
        this.eventWatcher = new EventWatcher();
    }

    public boolean start(Supplier<ManagedProcess> commandLauncher) {
        if (!this.lifecycle.tryToMoveTo(ManagedProcessLifecycle.State.STARTING)) {
            return false;
        }
        try {
            this.process = commandLauncher.get();
        }
        catch (RuntimeException e) {
            LOG.error("Fail to launch process [{}]", (Object)this.processId.getKey(), (Object)e);
            this.lifecycle.tryToMoveTo(ManagedProcessLifecycle.State.STOPPED);
            throw e;
        }
        this.stdOutGobbler = new StreamGobbler(this.process.getInputStream(), this.processId.getKey());
        this.stdOutGobbler.start();
        this.stdErrGobbler = new StreamGobbler(this.process.getErrorStream(), this.processId.getKey());
        this.stdErrGobbler.start();
        this.stopWatcher.start();
        this.eventWatcher.start();
        this.lifecycle.tryToMoveTo(ManagedProcessLifecycle.State.STARTED);
        return true;
    }

    public ProcessId getProcessId() {
        return this.processId;
    }

    ManagedProcessLifecycle.State getState() {
        return this.lifecycle.getState();
    }

    public void stop() throws InterruptedException {
        if (this.lifecycle.tryToMoveTo(ManagedProcessLifecycle.State.STOPPING)) {
            this.stopImpl();
            if (this.process != null && this.process.isAlive()) {
                LOG.info("{} failed to stop in a graceful fashion. Hard stopping it.", (Object)this.processId.getKey());
                this.hardStop();
            } else {
                this.stopForcibly();
            }
        } else {
            this.waitForDown();
        }
    }

    public void hardStop() throws InterruptedException {
        if (this.lifecycle.tryToMoveTo(ManagedProcessLifecycle.State.HARD_STOPPING)) {
            this.hardStopImpl();
            if (this.process != null && this.process.isAlive()) {
                LOG.info("{} failed to stop in a quick fashion. Killing it.", (Object)this.processId.getKey());
            }
            this.stopForcibly();
        } else {
            this.waitForDown();
        }
    }

    private void waitForDown() {
        while (this.process != null && this.process.isAlive()) {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void stopImpl() throws InterruptedException {
        if (this.process == null) {
            return;
        }
        try {
            this.process.askForStop();
            this.process.waitFor(this.stopTimeout.getDuration(), this.stopTimeout.getUnit());
        }
        catch (InterruptedException e) {
            throw ManagedProcessHandler.rethrowWithWarn(e, String.format("Interrupted while stopping process %s", this.processId));
        }
        catch (Throwable e) {
            LOG.error("Failed asking for graceful stop of process {}", (Object)this.processId, (Object)e);
        }
    }

    private void hardStopImpl() throws InterruptedException {
        if (this.process == null) {
            return;
        }
        try {
            this.process.askForHardStop();
            this.process.waitFor(this.hardStopTimeout.getDuration(), this.hardStopTimeout.getUnit());
        }
        catch (InterruptedException e) {
            throw ManagedProcessHandler.rethrowWithWarn(e, String.format("Interrupted while hard stopping process %s", this.processId));
        }
        catch (Throwable e) {
            LOG.error("Failed while asking for hard stop of process {}", (Object)this.processId, (Object)e);
        }
    }

    private static InterruptedException rethrowWithWarn(InterruptedException e, String errorMessage) {
        LOG.warn(errorMessage, (Throwable)e);
        Thread.currentThread().interrupt();
        return new InterruptedException(errorMessage);
    }

    public void stopForcibly() {
        this.eventWatcher.interrupt();
        this.stopWatcher.interrupt();
        if (this.process != null) {
            this.process.destroyForcibly();
            this.waitForDown();
            this.process.closeStreams();
        }
        if (this.stdOutGobbler != null) {
            StreamGobbler.waitUntilFinish(this.stdOutGobbler);
            this.stdOutGobbler.interrupt();
        }
        if (this.stdErrGobbler != null) {
            StreamGobbler.waitUntilFinish(this.stdErrGobbler);
            this.stdErrGobbler.interrupt();
        }
        this.lifecycle.tryToMoveTo(ManagedProcessLifecycle.State.STOPPED);
    }

    void refreshState() {
        if (this.process.isAlive()) {
            if (!this.operational && this.process.isOperational()) {
                this.operational = true;
                this.eventListeners.forEach(l -> l.onManagedProcessEvent(this.processId, ManagedProcessEventListener.Type.OPERATIONAL));
            }
            if (this.process.askedForRestart()) {
                this.process.acknowledgeAskForRestart();
                this.eventListeners.forEach(l -> l.onManagedProcessEvent(this.processId, ManagedProcessEventListener.Type.ASK_FOR_RESTART));
            }
        }
    }

    public String toString() {
        return String.format("Process[%s]", this.processId.getKey());
    }

    public static Builder builder(ProcessId processId) {
        return new Builder(processId);
    }

    public static final class Timeout {
        private final long duration;
        private final TimeUnit timeoutUnit;

        private Timeout(long duration, TimeUnit unit) {
            this.duration = duration;
            this.timeoutUnit = Objects.requireNonNull(unit, "unit can't be null");
        }

        public static Timeout newTimeout(long duration, TimeUnit unit) {
            return new Timeout(duration, unit);
        }

        public long getDuration() {
            return this.duration;
        }

        public TimeUnit getUnit() {
            return this.timeoutUnit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Timeout timeout = (Timeout)o;
            return this.duration == timeout.duration && this.timeoutUnit == timeout.timeoutUnit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.duration, this.timeoutUnit});
        }
    }

    public static class Builder {
        private final ProcessId processId;
        private final List<ManagedProcessEventListener> eventListeners = new ArrayList<ManagedProcessEventListener>();
        private final List<ProcessLifecycleListener> lifecycleListeners = new ArrayList<ProcessLifecycleListener>();
        private long watcherDelayMs = 500L;
        private Timeout stopTimeout;
        private Timeout hardStopTimeout;

        private Builder(ProcessId processId) {
            this.processId = processId;
        }

        public Builder addEventListener(ManagedProcessEventListener listener) {
            this.eventListeners.add(listener);
            return this;
        }

        public Builder addProcessLifecycleListener(ProcessLifecycleListener listener) {
            this.lifecycleListeners.add(listener);
            return this;
        }

        public Builder setWatcherDelayMs(long l) {
            this.watcherDelayMs = l;
            return this;
        }

        public Builder setStopTimeout(Timeout stopTimeout) {
            this.stopTimeout = Builder.ensureStopTimeoutNonNull(stopTimeout);
            return this;
        }

        public Builder setHardStopTimeout(Timeout hardStopTimeout) {
            this.hardStopTimeout = Builder.ensureHardStopTimeoutNonNull(hardStopTimeout);
            return this;
        }

        private static Timeout ensureStopTimeoutNonNull(Timeout stopTimeout) {
            return Objects.requireNonNull(stopTimeout, "stopTimeout can't be null");
        }

        private static Timeout ensureHardStopTimeoutNonNull(Timeout hardStopTimeout) {
            return Objects.requireNonNull(hardStopTimeout, "hardStopTimeout can't be null");
        }

        public ManagedProcessHandler build() {
            Builder.ensureStopTimeoutNonNull(this.stopTimeout);
            Builder.ensureHardStopTimeoutNonNull(this.hardStopTimeout);
            return new ManagedProcessHandler(this);
        }
    }

    private class EventWatcher
    extends Thread {
        EventWatcher() {
            super(String.format("EventWatcher[%s]", ManagedProcessHandler.this.processId.getKey()));
        }

        @Override
        public void run() {
            try {
                while (ManagedProcessHandler.this.process.isAlive()) {
                    ManagedProcessHandler.this.refreshState();
                    Thread.sleep(ManagedProcessHandler.this.watcherDelayMs);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class StopWatcher
    extends Thread {
        StopWatcher() {
            super(String.format("StopWatcher[%s]", ManagedProcessHandler.this.processId.getKey()));
        }

        @Override
        public void run() {
            try {
                ManagedProcessHandler.this.process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ManagedProcessHandler.this.stopForcibly();
        }
    }
}

