/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import java.util.Map;
import javax.annotation.Nullable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.sonar.api.security.ExternalUsersProvider;
import org.sonar.api.security.UserDetails;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.ldap.LdapContextFactory;
import org.sonar.plugins.ldap.LdapException;
import org.sonar.plugins.ldap.LdapUserMapping;

public class LdapUsersProvider
extends ExternalUsersProvider {
    private static final Logger LOG = Loggers.get(LdapUsersProvider.class);
    private final Map<String, LdapContextFactory> contextFactories;
    private final Map<String, LdapUserMapping> userMappings;

    public LdapUsersProvider(Map<String, LdapContextFactory> contextFactories, Map<String, LdapUserMapping> userMappings) {
        this.contextFactories = contextFactories;
        this.userMappings = userMappings;
    }

    private static String getAttributeValue(@Nullable Attribute attribute) throws NamingException {
        if (attribute == null) {
            return "";
        }
        return (String)attribute.get();
    }

    public UserDetails doGetUserDetails(ExternalUsersProvider.Context context) {
        return this.getUserDetails(context.getUsername());
    }

    public UserDetails getUserDetails(String username) {
        LOG.debug("Requesting details for user {}", (Object)username);
        if (this.userMappings.isEmpty()) {
            String errorMessage = String.format("Unable to retrieve details for user %s: No user mapping found.", username);
            LOG.debug(errorMessage);
            throw new LdapException(errorMessage);
        }
        UserDetails details = null;
        LdapException exception = null;
        for (String serverKey : this.userMappings.keySet()) {
            SearchResult searchResult = null;
            try {
                searchResult = this.userMappings.get(serverKey).createSearch(this.contextFactories.get(serverKey), username).returns(this.userMappings.get(serverKey).getEmailAttribute(), this.userMappings.get(serverKey).getRealNameAttribute()).findUnique();
            }
            catch (NamingException e) {
                LOG.debug(e.getMessage(), (Object)e);
                exception = new LdapException("Unable to retrieve details for user " + username + " in " + serverKey, e);
            }
            if (searchResult != null) {
                try {
                    details = this.mapUserDetails(serverKey, searchResult);
                    break;
                }
                catch (NamingException e) {
                    LOG.debug(e.getMessage(), (Object)e);
                    exception = new LdapException("Unable to retrieve details for user " + username + " in " + serverKey, e);
                    continue;
                }
            }
            LOG.debug("User {} not found in {}", (Object)username, (Object)serverKey);
        }
        if (details == null && exception != null) {
            throw exception;
        }
        return details;
    }

    private UserDetails mapUserDetails(String serverKey, SearchResult searchResult) throws NamingException {
        Attributes attributes = searchResult.getAttributes();
        UserDetails details = new UserDetails();
        details.setName(LdapUsersProvider.getAttributeValue(attributes.get(this.userMappings.get(serverKey).getRealNameAttribute())));
        details.setEmail(LdapUsersProvider.getAttributeValue(attributes.get(this.userMappings.get(serverKey).getEmailAttribute())));
        return details;
    }
}

