/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.ParenthesizedLike;

@Rule(key="S2761")
public class DoublePrefixOperatorCheck
extends Check {
    private static final UastNode.Kind[] KINDS = new UastNode.Kind[]{UastNode.Kind.LOGICAL_COMPLEMENT, UastNode.Kind.BITWISE_COMPLEMENT, UastNode.Kind.UNARY_MINUS, UastNode.Kind.UNARY_PLUS};
    private static final List<UastNode.Kind> KIND_LIST = Arrays.asList(KINDS);
    private Set<UastNode> prefixSet = new HashSet<UastNode>();

    public DoublePrefixOperatorCheck() {
        super(KINDS);
    }

    @Override
    public void enterFile(InputFile inputFile) throws IOException {
        this.prefixSet.clear();
        super.enterFile(inputFile);
    }

    @Override
    public void visitNode(UastNode node) {
        if (this.prefixSet.contains(node)) {
            return;
        }
        node.kinds.stream().filter(KIND_LIST::contains).findFirst().ifPresent(k -> this.checkDescendant((UastNode.Kind)k, node));
    }

    private void checkDescendant(UastNode.Kind kind, UastNode node) {
        Optional<UastNode> sameKindChildren = node.getChild(kind);
        if (sameKindChildren.isPresent()) {
            UastNode child2 = sameKindChildren.get();
            this.reportIssue(child2);
            return;
        }
        node.getChild(UastNode.Kind.PARENTHESIZED_EXPRESSION).ifPresent(child -> {
            UastNode expression = ParenthesizedLike.from(child).expression();
            if (expression.is(kind)) {
                this.reportIssue(expression);
            }
        });
    }

    private void reportIssue(UastNode child) {
        this.prefixSet.add(child);
        this.reportIssue(child, String.format("Use the \"%s\" operator just once or not at all.", child.firstToken().value));
    }
}

