/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.uast.UastNode;

public class FunctionLike {
    public static final UastNode.Kind KIND = UastNode.Kind.FUNCTION;
    private final UastNode node;
    private final UastNode name;
    private final UastNode block;

    private FunctionLike(UastNode node, UastNode name, UastNode block) {
        this.node = node;
        this.name = name;
        this.block = block;
    }

    @CheckForNull
    public static FunctionLike from(UastNode node) {
        if (node.is(KIND)) {
            Optional<UastNode> nameNode = node.getChild(UastNode.Kind.FUNCTION_NAME);
            if (!nameNode.isPresent()) {
                return null;
            }
            return node.getChild(UastNode.Kind.BLOCK).map(block -> new FunctionLike(node, (UastNode)nameNode.get(), (UastNode)block)).orElse(null);
        }
        return null;
    }

    public UastNode node() {
        return this.node;
    }

    public UastNode body() {
        return this.block;
    }

    public UastNode name() {
        return this.name;
    }

    public List<UastNode> resultList() {
        ArrayList<UastNode> result = new ArrayList<UastNode>();
        this.node.getDescendants(UastNode.Kind.RESULT_LIST, result::add, UastNode.Kind.BLOCK);
        return result;
    }

    public List<UastNode> parameters() {
        List<UastNode> parameters = this.node.getChildren(UastNode.Kind.PARAMETER);
        if (!parameters.isEmpty()) {
            return parameters;
        }
        return this.nestedParameters();
    }

    private List<UastNode> nestedParameters() {
        ArrayList parameters = new ArrayList();
        this.node.children.stream().forEach(child -> child.getDescendants(UastNode.Kind.PARAMETER, parameters::add, UastNode.Kind.BLOCK));
        return Collections.unmodifiableList(parameters);
    }
}

