/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.newindex.BuiltIndex;

class IndexDefinitionHash {
    private static final char DELIMITER = ',';

    private IndexDefinitionHash() {
    }

    static String of(BuiltIndex<?> index) {
        IndexType.IndexMainType mainType = index.getMainType();
        return IndexDefinitionHash.of(index.getSettings().toString(), new Map[]{ImmutableMap.of((Object)mainType.getIndex(), (Object)mainType), (Map)index.getRelationTypes().stream().collect(MoreCollectors.uniqueIndex(IndexType.IndexRelationType::getName, t -> t)), index.getAttributes()});
    }

    private static String of(String str, Map<?, ?> ... maps) {
        StringBuilder sb = new StringBuilder(str);
        for (Map<?, ?> map : maps) {
            IndexDefinitionHash.appendMap(sb, map);
        }
        return DigestUtils.sha256Hex((String)sb.toString());
    }

    private static void appendMap(StringBuilder sb, Map<?, ?> attributes) {
        for (Map.Entry<?, ?> entry : IndexDefinitionHash.sort(attributes).entrySet()) {
            sb.append(entry.getKey());
            sb.append(',');
            IndexDefinitionHash.appendObject(sb, entry.getValue());
            sb.append(',');
        }
    }

    private static void appendObject(StringBuilder sb, Object value) {
        if (value instanceof Object[]) {
            sb.append(Arrays.toString((Object[])value));
        } else if (value instanceof Map) {
            IndexDefinitionHash.appendMap(sb, (Map)value);
        } else if (value instanceof IndexType) {
            sb.append(((IndexType)value).format());
        } else {
            sb.append(String.valueOf(value));
        }
    }

    private static SortedMap<?, ?> sort(Map<?, ?> map) {
        if (map instanceof ImmutableSortedMap) {
            return (ImmutableSortedMap)map;
        }
        return ImmutableSortedMap.copyOf(map);
    }
}

