/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.text.JsonWriter;

public class SearchOptions {
    public static final int DEFAULT_OFFSET = 0;
    public static final int DEFAULT_LIMIT = 10;
    public static final int MAX_LIMIT = 500;
    private static final int MAX_RETURNABLE_RESULTS = 10000;
    private int offset = 0;
    private int limit = 10;
    private final Set<String> facets = new LinkedHashSet<String>();
    private final Set<String> fieldsToReturn = new HashSet<String>();

    public int getOffset() {
        return this.offset;
    }

    public SearchOptions setOffset(int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset must be positive");
        this.offset = offset;
        return this;
    }

    public SearchOptions setPage(int page, int pageSize) {
        Preconditions.checkArgument((page >= 1 ? 1 : 0) != 0, (Object)("Page must be greater or equal to 1 (got " + page + ")"));
        int lastResultIndex = page * pageSize;
        Preconditions.checkArgument((lastResultIndex <= 10000 ? 1 : 0) != 0, (String)"Can return only the first %s results. %sth result asked.", (Object[])new Object[]{10000, lastResultIndex});
        this.setLimit(pageSize);
        this.setOffset(page * this.limit - this.limit);
        return this;
    }

    public int getPage() {
        return this.limit > 0 ? (int)Math.ceil((double)(this.offset + 1) / (double)this.limit) : 0;
    }

    public int getLimit() {
        return this.limit;
    }

    public SearchOptions setLimit(int limit) {
        this.limit = limit <= 0 ? 500 : Math.min(limit, 500);
        return this;
    }

    public Collection<String> getFacets() {
        return this.facets;
    }

    public SearchOptions addFacets(@Nullable Collection<String> f) {
        if (f != null) {
            this.facets.addAll(f);
        }
        return this;
    }

    public SearchOptions addFacets(String ... array) {
        Collections.addAll(this.facets, array);
        return this;
    }

    public Set<String> getFields() {
        return this.fieldsToReturn;
    }

    public SearchOptions addFields(@Nullable Collection<String> c) {
        if (c != null) {
            for (String s : c) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                this.fieldsToReturn.add(s);
            }
        }
        return this;
    }

    public SearchOptions writeJson(JsonWriter json, long totalHits) {
        json.prop("total", totalHits);
        json.prop("p", (long)this.getPage());
        json.prop("ps", (long)this.getLimit());
        return this;
    }
}

