/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import org.picocontainer.Startable;
import org.sonar.api.platform.Server;
import org.sonar.api.platform.ServerStartHandler;
import org.sonar.api.platform.ServerStopHandler;
import org.sonar.api.utils.log.Loggers;

public class ServerLifecycleNotifier
implements Startable {
    private ServerStartHandler[] startHandlers;
    private ServerStopHandler[] stopHandlers;
    private Server server;

    public ServerLifecycleNotifier(Server server, ServerStartHandler[] startHandlers, ServerStopHandler[] stopHandlers) {
        this.startHandlers = startHandlers;
        this.stopHandlers = stopHandlers;
        this.server = server;
    }

    public ServerLifecycleNotifier(Server server, ServerStartHandler[] startHandlers) {
        this(server, startHandlers, new ServerStopHandler[0]);
    }

    public ServerLifecycleNotifier(Server server, ServerStopHandler[] stopHandlers) {
        this(server, new ServerStartHandler[0], stopHandlers);
    }

    public ServerLifecycleNotifier(Server server) {
        this(server, new ServerStartHandler[0], new ServerStopHandler[0]);
    }

    public void start() {
    }

    public void notifyStart() {
        Loggers.get(ServerLifecycleNotifier.class).debug("Notify " + ServerStartHandler.class.getSimpleName() + " handlers...");
        for (ServerStartHandler handler : this.startHandlers) {
            handler.onServerStart(this.server);
        }
    }

    public void stop() {
        Loggers.get(ServerLifecycleNotifier.class).debug("Notify " + ServerStopHandler.class.getSimpleName() + " handlers...");
        for (ServerStopHandler handler : this.stopHandlers) {
            handler.onServerStop(this.server);
        }
    }
}

