/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ConditionComparator<T>
implements Comparator<T> {
    private static final List<String> CONDITIONS_ORDER = Arrays.asList("new_reliability_rating", "reliability_rating", "new_security_rating", "security_rating", "new_maintainability_rating", "sqale_rating", "new_coverage", "coverage", "new_duplicated_lines_density", "duplicated_lines_density");
    private static final Map<String, Integer> CONDITIONS_ORDER_IDX = IntStream.range(0, CONDITIONS_ORDER.size()).boxed().collect(Collectors.toMap(CONDITIONS_ORDER::get, x -> x));
    private final Function<T, String> metricKeyExtractor;

    public ConditionComparator(Function<T, String> metricKeyExtractor) {
        this.metricKeyExtractor = metricKeyExtractor;
    }

    @Override
    public int compare(T c1, T c2) {
        Function<Object, Integer> byList = c -> CONDITIONS_ORDER_IDX.getOrDefault(this.metricKeyExtractor.apply(c), Integer.MAX_VALUE);
        return Comparator.comparing(byList).thenComparing(this.metricKeyExtractor).compare(c1, c2);
    }
}

