/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RuleQuery;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.rule.RuleDao;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.markdown.Markdown;
import org.sonar.server.organization.DefaultOrganizationProvider;

public class DefaultRuleFinder
implements RuleFinder {
    private final DbClient dbClient;
    private final RuleDao ruleDao;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public DefaultRuleFinder(DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.ruleDao = dbClient.ruleDao();
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    @CheckForNull
    public Rule findById(int ruleId) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional rule = this.ruleDao.selectById((long)ruleId, this.defaultOrganizationProvider.get().getUuid(), dbSession);
            if (rule.isPresent() && ((RuleDto)rule.get()).getStatus() != RuleStatus.REMOVED) {
                Rule rule2 = DefaultRuleFinder.toRule((RuleDto)rule.get(), this.ruleDao.selectRuleParamsByRuleKey(dbSession, ((RuleDto)rule.get()).getKey()));
                return rule2;
            }
            Rule rule3 = null;
            return rule3;
        }
    }

    @CheckForNull
    public Rule findByKey(RuleKey key) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String defaultOrganizationUuid = this.defaultOrganizationProvider.get().getUuid();
            OrganizationDto defaultOrganization = (OrganizationDto)this.dbClient.organizationDao().selectByUuid(dbSession, defaultOrganizationUuid).orElseThrow(() -> new IllegalStateException(String.format("Cannot find default organization '%s'", defaultOrganizationUuid)));
            Optional rule = this.ruleDao.selectByKey(dbSession, defaultOrganization.getUuid(), key);
            if (rule.isPresent() && ((RuleDto)rule.get()).getStatus() != RuleStatus.REMOVED) {
                Rule rule2 = DefaultRuleFinder.toRule((RuleDto)rule.get(), this.ruleDao.selectRuleParamsByRuleKey(dbSession, ((RuleDto)rule.get()).getKey()));
                return rule2;
            }
            Rule rule3 = null;
            return rule3;
        }
    }

    @CheckForNull
    public Rule findByKey(String repositoryKey, String key) {
        return this.findByKey(RuleKey.of((String)repositoryKey, (String)key));
    }

    public final Rule find(RuleQuery query) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List rules = this.ruleDao.selectByQuery(dbSession, this.defaultOrganizationProvider.get().getUuid(), query);
            if (!rules.isEmpty()) {
                RuleDto rule = (RuleDto)rules.get(0);
                Rule rule2 = DefaultRuleFinder.toRule(rule, this.ruleDao.selectRuleParamsByRuleKey(dbSession, rule.getKey()));
                return rule2;
            }
            Rule rule = null;
            return rule;
        }
    }

    public final Collection<Rule> findAll(RuleQuery query) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List rules = this.ruleDao.selectByQuery(dbSession, this.defaultOrganizationProvider.get().getUuid(), query);
            if (rules.isEmpty()) {
                List<Rule> list = Collections.emptyList();
                return list;
            }
            Collection<Rule> collection = this.convertToRuleApi(dbSession, rules);
            return collection;
        }
    }

    private Collection<Rule> convertToRuleApi(DbSession dbSession, List<RuleDto> ruleDtos) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ImmutableList ruleKeys = FluentIterable.from(ruleDtos).transform((Function)RuleDtoToKey.INSTANCE).toList();
        List ruleParamDtos = this.ruleDao.selectRuleParamsByRuleKeys(dbSession, (Collection)ruleKeys);
        ImmutableListMultimap ruleParamByRuleId = FluentIterable.from((Iterable)ruleParamDtos).index((Function)RuleParamDtoToRuleId.INSTANCE);
        for (RuleDto rule : ruleDtos) {
            rules.add(DefaultRuleFinder.toRule(rule, (List<RuleParamDto>)ruleParamByRuleId.get((Object)rule.getId())));
        }
        return rules;
    }

    private static Rule toRule(RuleDto rule, List<RuleParamDto> params) {
        String severity = rule.getSeverityString();
        String description = rule.getDescription();
        RuleDto.Format descriptionFormat = rule.getDescriptionFormat();
        Rule apiRule = new Rule();
        apiRule.setName(rule.getName()).setLanguage(rule.getLanguage()).setKey(rule.getRuleKey()).setConfigKey(rule.getConfigKey()).setIsTemplate(rule.isTemplate()).setCreatedAt(new Date(rule.getCreatedAt())).setUpdatedAt(new Date(rule.getUpdatedAt())).setRepositoryKey(rule.getRepositoryKey()).setSeverity(severity != null ? RulePriority.valueOf((String)severity) : null).setStatus(rule.getStatus().name()).setSystemTags(rule.getSystemTags().toArray(new String[rule.getSystemTags().size()])).setTags(rule.getTags().toArray(new String[rule.getTags().size()])).setId(rule.getId());
        if (description != null && descriptionFormat != null) {
            if (RuleDto.Format.HTML.equals((Object)descriptionFormat)) {
                apiRule.setDescription(description);
            } else {
                apiRule.setDescription(Markdown.convertToHtml((String)description));
            }
        }
        ArrayList apiParams = Lists.newArrayList();
        for (RuleParamDto param : params) {
            apiParams.add(new RuleParam(apiRule, param.getName(), param.getDescription(), param.getType()).setDefaultValue(param.getDefaultValue()));
        }
        apiRule.setParams((List)apiParams);
        return apiRule;
    }

    private static enum RuleParamDtoToRuleId implements Function<RuleParamDto, Integer>
    {
        INSTANCE;


        public Integer apply(@Nonnull RuleParamDto input) {
            return input.getRuleId();
        }
    }

    private static enum RuleDtoToKey implements Function<RuleDto, RuleKey>
    {
        INSTANCE;


        public RuleKey apply(@Nonnull RuleDto input) {
            return input.getKey();
        }
    }
}

