/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.index;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class UserQuery {
    private final String textQuery;
    private final String organizationUuid;
    private final String excludedOrganizationUuid;

    private UserQuery(Builder builder) {
        this.textQuery = builder.textQuery;
        this.organizationUuid = builder.organizationUuid;
        this.excludedOrganizationUuid = builder.excludedOrganizationUuid;
    }

    public Optional<String> getTextQuery() {
        return Optional.ofNullable(this.textQuery);
    }

    public Optional<String> getOrganizationUuid() {
        return Optional.ofNullable(this.organizationUuid);
    }

    public Optional<String> getExcludedOrganizationUuid() {
        return Optional.ofNullable(this.excludedOrganizationUuid);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String textQuery;
        private String organizationUuid;
        private String excludedOrganizationUuid;

        private Builder() {
        }

        public UserQuery build() {
            return new UserQuery(this);
        }

        public Builder setTextQuery(@Nullable String textQuery) {
            this.textQuery = StringUtils.isBlank((String)textQuery) ? null : textQuery;
            return this;
        }

        public Builder setOrganizationUuid(@Nullable String organizationUuid) {
            this.organizationUuid = organizationUuid;
            return this;
        }

        public Builder setExcludedOrganizationUuid(@Nullable String excludedOrganizationUuid) {
            this.excludedOrganizationUuid = excludedOrganizationUuid;
            return this;
        }
    }
}

