/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.core.component.ComponentKeys;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchMapper;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentKeyUpdaterMapper;
import org.sonar.db.component.ResourceDto;

public class ComponentKeyUpdaterDao
implements Dao {
    private static final Set<String> PROJECT_OR_MODULE_QUALIFIERS = ImmutableSet.of((Object)"TRK", (Object)"BRC");

    public void updateKey(DbSession dbSession, String projectOrModuleUuid, String newKey) {
        ComponentKeyUpdaterMapper mapper = (ComponentKeyUpdaterMapper)dbSession.getMapper(ComponentKeyUpdaterMapper.class);
        if (mapper.countResourceByKey(newKey) > 0) {
            throw new IllegalArgumentException("Impossible to update key: a component with key \"" + newKey + "\" already exists.");
        }
        ResourceDto project = mapper.selectProjectByUuid(projectOrModuleUuid);
        String projectOldKey = project.getKey();
        List<ResourceDto> resources = mapper.selectProjectResources(projectOrModuleUuid);
        resources.add(project);
        ((BranchMapper)dbSession.getMapper(BranchMapper.class)).selectByProjectUuid(projectOrModuleUuid).stream().filter(branch -> !projectOrModuleUuid.equals(branch.getUuid())).forEach(branch -> {
            resources.addAll(mapper.selectProjectResources(branch.getUuid()));
            resources.add(mapper.selectProjectByUuid(branch.getUuid()));
        });
        ComponentKeyUpdaterDao.runBatchUpdateForAllResources(resources, projectOldKey, newKey, mapper, (resource, oldKey) -> {});
    }

    public static void checkIsProjectOrModule(ComponentDto component) {
        Preconditions.checkArgument((boolean)PROJECT_OR_MODULE_QUALIFIERS.contains(component.qualifier()), (Object)"Component updated must be a module or a key");
    }

    public Map<String, String> simulateBulkUpdateKey(DbSession dbSession, String projectUuid, String stringToReplace, String replacementString) {
        return ComponentKeyUpdaterDao.collectAllModules(projectUuid, stringToReplace, ComponentKeyUpdaterDao.mapper(dbSession), false).stream().collect(Collectors.toMap(ResourceDto::getKey, component -> {
            String newKey = ComponentKeyUpdaterDao.computeNewKey(component.getKey(), stringToReplace, replacementString);
            ComponentKeys.checkProjectKey((String)newKey);
            return newKey;
        }));
    }

    public Map<String, Boolean> checkComponentKeys(DbSession dbSession, List<String> newComponentKeys) {
        return newComponentKeys.stream().collect(Collectors.toMap(Function.identity(), key -> ComponentKeyUpdaterDao.mapper(dbSession).countResourceByKey((String)key) > 0));
    }

    @VisibleForTesting
    static String computeNewKey(String key, String stringToReplace, String replacementString) {
        return key.replace(stringToReplace, replacementString);
    }

    public Set<RekeyedResource> bulkUpdateKey(DbSession session, String projectUuid, String stringToReplace, String replacementString, Predicate<RekeyedResource> rekeyedResourceFilter) {
        ComponentKeyUpdaterMapper mapper = (ComponentKeyUpdaterMapper)session.getMapper(ComponentKeyUpdaterMapper.class);
        Set<ResourceDto> modules = ComponentKeyUpdaterDao.collectAllModules(projectUuid, stringToReplace, mapper, true);
        ComponentKeyUpdaterDao.checkNewNameOfAllModules(modules, stringToReplace, replacementString, mapper);
        HashMap branchBaseKeys = new HashMap();
        ((BranchMapper)session.getMapper(BranchMapper.class)).selectByProjectUuid(projectUuid).stream().filter(branch -> !projectUuid.equals(branch.getUuid())).forEach(branch -> {
            Set<ResourceDto> branchModules = ComponentKeyUpdaterDao.collectAllModules(branch.getUuid(), stringToReplace, mapper, true);
            modules.addAll(branchModules);
            branchModules.forEach(module -> branchBaseKeys.put(module.getKey(), ComponentKeyUpdaterDao.branchBaseKey(module.getKey())));
        });
        HashMap allResourcesByModuleMap = Maps.newHashMap();
        for (ResourceDto module : modules) {
            allResourcesByModuleMap.put(module, mapper.selectProjectResources(module.getUuid()));
        }
        HashSet<RekeyedResource> rekeyedResources = new HashSet<RekeyedResource>();
        for (ResourceDto module : modules) {
            String oldModuleKey = module.getKey();
            oldModuleKey = branchBaseKeys.getOrDefault(oldModuleKey, oldModuleKey);
            String newModuleKey = ComponentKeyUpdaterDao.computeNewKey(oldModuleKey, stringToReplace, replacementString);
            ArrayList resources = Lists.newArrayList((Object[])new ResourceDto[]{module});
            resources.addAll((Collection)allResourcesByModuleMap.get(module));
            ComponentKeyUpdaterDao.runBatchUpdateForAllResources(resources, oldModuleKey, newModuleKey, mapper, (resource, oldKey) -> {
                RekeyedResource rekeyedResource = new RekeyedResource((ResourceDto)resource, (String)oldKey);
                if (rekeyedResourceFilter.test(rekeyedResource)) {
                    rekeyedResources.add(rekeyedResource);
                }
            });
        }
        return rekeyedResources;
    }

    private static String branchBaseKey(String key) {
        int index = key.lastIndexOf(":BRANCH:");
        if (index > -1) {
            return key.substring(0, index);
        }
        index = key.lastIndexOf(":PULL_REQUEST:");
        if (index > -1) {
            return key.substring(0, index);
        }
        return key;
    }

    private static void runBatchUpdateForAllResources(Collection<ResourceDto> resources, String oldKey, String newKey, ComponentKeyUpdaterMapper mapper, @Nullable BiConsumer<ResourceDto, String> consumer) {
        for (ResourceDto resource : resources) {
            String oldResourceKey = resource.getKey();
            String newResourceKey = newKey + oldResourceKey.substring(oldKey.length(), oldResourceKey.length());
            resource.setKey(newResourceKey);
            String oldResourceDeprecatedKey = resource.getDeprecatedKey();
            if (StringUtils.isNotBlank((String)oldResourceDeprecatedKey)) {
                String newResourceDeprecatedKey = newKey + oldResourceDeprecatedKey.substring(oldKey.length(), oldResourceDeprecatedKey.length());
                resource.setDeprecatedKey(newResourceDeprecatedKey);
            }
            mapper.update(resource);
            if (consumer == null) continue;
            consumer.accept(resource, oldResourceKey);
        }
    }

    private static Set<ResourceDto> collectAllModules(String projectUuid, String stringToReplace, ComponentKeyUpdaterMapper mapper, boolean includeDisabled) {
        ResourceDto project = mapper.selectProjectByUuid(projectUuid);
        HashSet<ResourceDto> modules = new HashSet<ResourceDto>();
        if (project.getKey().contains(stringToReplace) && (project.isEnabled() || includeDisabled)) {
            modules.add(project);
        }
        for (ResourceDto submodule : mapper.selectDescendantProjects(projectUuid)) {
            modules.addAll(ComponentKeyUpdaterDao.collectAllModules(submodule.getUuid(), stringToReplace, mapper, includeDisabled));
        }
        return modules;
    }

    private static void checkNewNameOfAllModules(Set<ResourceDto> modules, String stringToReplace, String replacementString, ComponentKeyUpdaterMapper mapper) {
        for (ResourceDto module : modules) {
            String newKey = ComponentKeyUpdaterDao.computeNewKey(module.getKey(), stringToReplace, replacementString);
            ComponentKeys.checkProjectKey((String)newKey);
            if (mapper.countResourceByKey(newKey) <= 0) continue;
            throw new IllegalArgumentException("Impossible to update key: a component with key \"" + newKey + "\" already exists.");
        }
    }

    private static ComponentKeyUpdaterMapper mapper(DbSession dbSession) {
        return (ComponentKeyUpdaterMapper)dbSession.getMapper(ComponentKeyUpdaterMapper.class);
    }

    public static final class RekeyedResource {
        private final ResourceDto resource;
        private final String oldKey;

        public RekeyedResource(ResourceDto resource, String oldKey) {
            this.resource = resource;
            this.oldKey = oldKey;
        }

        public ResourceDto getResource() {
            return this.resource;
        }

        public String getOldKey() {
            return this.oldKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RekeyedResource that = (RekeyedResource)o;
            return Objects.equals(this.resource.getUuid(), that.resource.getUuid());
        }

        public int hashCode() {
            return this.resource.getUuid().hashCode();
        }
    }
}

