/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.rule;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleRepositoryDto;
import org.sonar.db.rule.RuleRepositoryMapper;

public class RuleRepositoryDao
implements Dao {
    private final System2 system2;

    public RuleRepositoryDao(System2 system2) {
        this.system2 = system2;
    }

    public List<RuleRepositoryDto> selectAll(DbSession dbSession) {
        return ((RuleRepositoryMapper)dbSession.getMapper(RuleRepositoryMapper.class)).selectAll();
    }

    public List<RuleRepositoryDto> selectByLanguage(DbSession dbSession, String language) {
        return ((RuleRepositoryMapper)dbSession.getMapper(RuleRepositoryMapper.class)).selectByLanguage(language);
    }

    public void insertOrUpdate(DbSession dbSession, Collection<RuleRepositoryDto> dtos) {
        RuleRepositoryMapper mapper = (RuleRepositoryMapper)dbSession.getMapper(RuleRepositoryMapper.class);
        long now = this.system2.now();
        for (RuleRepositoryDto dto : dtos) {
            int updated = mapper.update(dto);
            if (updated != 0) continue;
            mapper.insert(dto, now);
        }
    }

    public void deleteIfKeyNotIn(DbSession dbSession, Collection<String> keys) {
        Preconditions.checkArgument((keys.size() < 1000 ? 1 : 0) != 0, (String)"too many rule repositories: %s", (Object[])new Object[]{keys.size()});
        ((RuleRepositoryMapper)dbSession.getMapper(RuleRepositoryMapper.class)).deleteIfKeyNotIn(keys);
    }
}

