/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.app;

import java.io.File;
import org.sonar.api.config.Configuration;
import org.sonar.process.ProcessId;
import org.sonar.process.sharedmemoryfile.DefaultProcessCommands;
import org.sonar.process.sharedmemoryfile.ProcessCommands;
import org.sonar.server.app.ProcessCommandWrapper;

public class ProcessCommandWrapperImpl
implements ProcessCommandWrapper {
    private static final ProcessMethod<Void> SET_OPERATIONAL = processCommands -> {
        processCommands.setOperational();
        return null;
    };
    private static final ProcessMethod<Void> ASK_FOR_RESTART = processCommands -> {
        processCommands.askForRestart();
        return null;
    };
    private static final ProcessMethod<Void> ASK_FOR_HARD_STOP = processCommands -> {
        processCommands.askForHardStop();
        return null;
    };
    private static final ProcessMethod<Boolean> IS_OPERATIONAL = ProcessCommands::isOperational;
    private final Configuration config;

    public ProcessCommandWrapperImpl(Configuration config) {
        this.config = config;
    }

    @Override
    public void requestSQRestart() {
        this.call(ASK_FOR_RESTART, this.selfProcessNumber());
    }

    @Override
    public void requestHardStop() {
        this.call(ASK_FOR_HARD_STOP, this.selfProcessNumber());
    }

    @Override
    public void notifyOperational() {
        this.call(SET_OPERATIONAL, this.selfProcessNumber());
    }

    @Override
    public boolean isCeOperational() {
        return this.call(IS_OPERATIONAL, ProcessId.COMPUTE_ENGINE.getIpcIndex());
    }

    private int selfProcessNumber() {
        return this.nonNullAsInt("process.index");
    }

    private <T> T call(ProcessMethod<T> command, int processNumber) {
        File shareDir = this.nonNullValueAsFile("process.sharedDir");
        try (DefaultProcessCommands commands = DefaultProcessCommands.secondary((File)shareDir, (int)processNumber);){
            T t = command.callOn((ProcessCommands)commands);
            return t;
        }
    }

    private int nonNullAsInt(String key) {
        return (Integer)this.config.getInt(key).orElseThrow(() -> new IllegalArgumentException(String.format("Property %s is not set", key)));
    }

    private File nonNullValueAsFile(String key) {
        return new File((String)this.config.get(key).orElseThrow(() -> new IllegalArgumentException(String.format("Property %s is not set", key))));
    }

    private static interface ProcessMethod<T> {
        public T callOn(ProcessCommands var1);
    }
}

