/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.issue.index.IssueQuery;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Issues;

public class AuthorsAction
implements IssuesWsAction {
    private static final String PARAM_ORGANIZATION = "organization";
    private static final String PARAM_PROJECT = "project";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final IssueIndex issueIndex;
    private final ComponentFinder componentFinder;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public AuthorsAction(UserSession userSession, DbClient dbClient, IssueIndex issueIndex, ComponentFinder componentFinder, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.issueIndex = issueIndex;
        this.componentFinder = componentFinder;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("authors").setSince("5.1").setDescription("Search SCM accounts which match a given query.<br/>Requires authentication.").setResponseExample(Resources.getResource(this.getClass(), (String)"authors-example.json")).setChangelog(new Change[]{new Change("7.4", "The maximum size of 'ps' is set to 100")}).setHandler((RequestHandler)this);
        action.createSearchQuery("luke", new String[]{"authors"});
        action.createPageSize(10, 100);
        action.createParam(PARAM_ORGANIZATION).setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("7.4");
        action.createParam(PARAM_PROJECT).setDescription("Project key").setRequired(false).setExampleValue((Object)"my_project").setSince("7.4");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.getOrganization(dbSession, request.param(PARAM_ORGANIZATION));
            this.userSession.checkMembership(organization);
            Optional<ComponentDto> project = this.getProject(dbSession, organization, request.param(PARAM_PROJECT));
            List<String> authors = this.getAuthors(organization, project, request);
            Issues.AuthorsResponse wsResponse = Issues.AuthorsResponse.newBuilder().addAllAuthors(authors).build();
            WsUtils.writeProtobuf((Message)wsResponse, request, response);
        }
    }

    private OrganizationDto getOrganization(DbSession dbSession, @Nullable String organizationKey) {
        String organizationOrDefaultKey = Optional.ofNullable(organizationKey).orElseGet(() -> ((DefaultOrganization)this.defaultOrganizationProvider.get()).getKey());
        return (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationOrDefaultKey), "No organization with key '%s'", organizationOrDefaultKey);
    }

    private Optional<ComponentDto> getProject(DbSession dbSession, OrganizationDto organization, @Nullable String projectKey) {
        if (projectKey == null) {
            return Optional.empty();
        }
        ComponentDto project = this.componentFinder.getByKey(dbSession, projectKey);
        Preconditions.checkArgument((boolean)project.scope().equals("PRJ"), (String)"Component '%s' must be a project", (Object[])new Object[]{projectKey});
        Preconditions.checkArgument((boolean)project.getOrganizationUuid().equals(organization.getUuid()), (String)"Project '%s' is not part of the organization '%s'", (Object[])new Object[]{projectKey, organization.getKey()});
        return Optional.of(project);
    }

    private List<String> getAuthors(OrganizationDto organization, Optional<ComponentDto> project, Request request) {
        IssueQuery.Builder issueQueryBuilder = IssueQuery.builder().organizationUuid(organization.getUuid());
        project.ifPresent(p -> {
            switch (p.qualifier()) {
                case "TRK": {
                    issueQueryBuilder.projectUuids((Collection<String>)ImmutableSet.of((Object)p.uuid()));
                    return;
                }
                case "APP": 
                case "VW": {
                    issueQueryBuilder.viewUuids((Collection<String>)ImmutableSet.of((Object)p.uuid()));
                    return;
                }
            }
            throw new IllegalArgumentException(String.format("Component of type '%s' is not supported", p.qualifier()));
        });
        return this.issueIndex.searchAuthors(issueQueryBuilder.build(), request.param("q"), request.mandatoryParamAsInt("ps"));
    }
}

