/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.rules.RuleType;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.protobuf.DbIssues;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.es.Facets;
import org.sonar.server.issue.TransitionService;
import org.sonar.server.issue.ws.SearchAdditionalField;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;

public class SearchResponseLoader {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final TransitionService transitionService;

    public SearchResponseLoader(UserSession userSession, DbClient dbClient, TransitionService transitionService) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.transitionService = transitionService;
    }

    public SearchResponseData load(SearchResponseData preloadedResponseData, Collector collector, Set<SearchAdditionalField> fields, @Nullable Facets facets) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SearchResponseData result = new SearchResponseData(this.loadIssues(preloadedResponseData, collector, dbSession));
            collector.collect(result.getIssues());
            this.loadRules(preloadedResponseData, collector, dbSession, result);
            this.loadComments(collector, dbSession, fields, result);
            this.loadUsers(preloadedResponseData, collector, dbSession, result);
            this.loadComponents(preloadedResponseData, collector, dbSession, result);
            this.loadOrganizations(dbSession, result);
            this.loadActionsAndTransitions(result, fields);
            SearchResponseLoader.completeTotalEffortFromFacet(facets, result);
            SearchResponseData searchResponseData = result;
            return searchResponseData;
        }
    }

    private List<IssueDto> loadIssues(SearchResponseData preloadedResponseData, Collector collector, DbSession dbSession) {
        List<IssueDto> preloadedIssues = preloadedResponseData.getIssues();
        Set preloadedIssueKeys = (Set)preloadedIssues.stream().map(IssueDto::getKey).collect(MoreCollectors.toSet((int)preloadedIssues.size()));
        ImmutableSet issueKeys = ImmutableSet.copyOf(collector.getIssueKeys());
        ImmutableSet issueKeysToLoad = ImmutableSet.copyOf((Collection)Sets.difference((Set)issueKeys, (Set)preloadedIssueKeys));
        if (issueKeysToLoad.isEmpty()) {
            return issueKeys.stream().map(new KeyToIssueFunction(preloadedIssues)::apply).filter(Objects::nonNull).collect(Collectors.toList());
        }
        List loadedIssues = this.dbClient.issueDao().selectByKeys(dbSession, (Collection)issueKeysToLoad);
        List unorderedIssues = (List)Stream.concat(preloadedIssues.stream(), loadedIssues.stream()).collect(MoreCollectors.toList((int)(preloadedIssues.size() + loadedIssues.size())));
        return issueKeys.stream().map(new KeyToIssueFunction(unorderedIssues)::apply).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void loadUsers(SearchResponseData preloadedResponseData, Collector collector, DbSession dbSession, SearchResponseData result) {
        Set<String> usersUuidToLoad = collector.getUserUuids();
        List preloadedUsers = (List)MoreObjects.firstNonNull(preloadedResponseData.getUsers(), Collections.emptyList());
        result.addUsers(preloadedUsers);
        preloadedUsers.forEach(userDto -> usersUuidToLoad.remove(userDto.getUuid()));
        result.addUsers(this.dbClient.userDao().selectByUuids(dbSession, usersUuidToLoad));
    }

    private void loadComponents(SearchResponseData preloadedResponseData, Collector collector, DbSession dbSession, SearchResponseData result) {
        Collection<ComponentDto> preloadedComponents = preloadedResponseData.getComponents();
        Set preloadedComponentUuids = (Set)preloadedComponents.stream().map(ComponentDto::uuid).collect(MoreCollectors.toSet((int)preloadedComponents.size()));
        ImmutableSet componentUuidsToLoad = ImmutableSet.copyOf((Collection)Sets.difference(collector.getComponentUuids(), (Set)preloadedComponentUuids));
        result.addComponents(preloadedComponents);
        if (!componentUuidsToLoad.isEmpty()) {
            result.addComponents(this.dbClient.componentDao().selectByUuids(dbSession, (Collection)componentUuidsToLoad));
        }
        result.addComponents(this.dbClient.componentDao().selectSubProjectsByComponentUuids(dbSession, collector.getComponentUuids()));
        this.loadProjects(collector, dbSession, result);
    }

    private void loadProjects(Collector collector, DbSession dbSession, SearchResponseData result) {
        Collection<ComponentDto> loadedComponents = result.getComponents();
        for (ComponentDto component : loadedComponents) {
            collector.addProjectUuid(component.projectUuid());
        }
        Set loadedProjectUuids = (Set)loadedComponents.stream().filter(cpt -> cpt.uuid().equals(cpt.projectUuid())).map(ComponentDto::uuid).collect(MoreCollectors.toSet());
        ImmutableSet projectUuidsToLoad = ImmutableSet.copyOf((Collection)Sets.difference(collector.getProjectUuids(), (Set)loadedProjectUuids));
        if (!projectUuidsToLoad.isEmpty()) {
            List projects = this.dbClient.componentDao().selectByUuids(dbSession, collector.getProjectUuids());
            result.addComponents(projects);
        }
    }

    private void loadRules(SearchResponseData preloadedResponseData, Collector collector, DbSession dbSession, SearchResponseData result) {
        List preloadedRules = (List)MoreObjects.firstNonNull(preloadedResponseData.getRules(), Collections.emptyList());
        result.addRules(preloadedRules);
        Set<Integer> ruleIdsToLoad = collector.getRuleIds();
        ruleIdsToLoad.removeAll((Collection)preloadedRules.stream().map(RuleDefinitionDto::getId).collect(MoreCollectors.toList((int)preloadedRules.size())));
        result.addRules(this.dbClient.ruleDao().selectDefinitionByIds(dbSession, ruleIdsToLoad));
    }

    private void loadComments(Collector collector, DbSession dbSession, Set<SearchAdditionalField> fields, SearchResponseData result) {
        if (fields.contains((Object)SearchAdditionalField.COMMENTS)) {
            List comments = this.dbClient.issueChangeDao().selectByTypeAndIssueKeys(dbSession, collector.getIssueKeys(), "comment");
            result.setComments(comments);
            for (IssueChangeDto comment : comments) {
                collector.addUserUuids(Collections.singletonList(comment.getUserUuid()));
                if (!this.canEditOrDelete(comment)) continue;
                result.addUpdatableComment(comment.getKey());
            }
        }
    }

    private boolean canEditOrDelete(IssueChangeDto dto) {
        return this.userSession.isLoggedIn() && Objects.requireNonNull(this.userSession.getUuid(), "User uuid should not be null").equals(dto.getUserUuid());
    }

    private void loadOrganizations(DbSession dbSession, SearchResponseData result) {
        Collection<ComponentDto> components = result.getComponents();
        this.dbClient.organizationDao().selectByUuids(dbSession, (Set)components.stream().map(ComponentDto::getOrganizationUuid).collect(MoreCollectors.toSet())).forEach(result::addOrganization);
        if (this.userSession.isLoggedIn()) {
            result.setUserOrganizationUuids(this.dbClient.organizationMemberDao().selectOrganizationUuidsByUser(dbSession, this.userSession.getUserId().intValue()));
        }
    }

    private void loadActionsAndTransitions(SearchResponseData result, Set<SearchAdditionalField> fields) {
        if (fields.contains((Object)SearchAdditionalField.ACTIONS) || fields.contains((Object)SearchAdditionalField.TRANSITIONS)) {
            Map componentsByProjectUuid = (Map)result.getComponents().stream().filter(ComponentDto::isRootProject).collect(MoreCollectors.uniqueIndex(ComponentDto::projectUuid));
            for (IssueDto issueDto : result.getIssues()) {
                if (fields.contains((Object)SearchAdditionalField.ACTIONS)) {
                    ComponentDto project = (ComponentDto)componentsByProjectUuid.get(issueDto.getProjectUuid());
                    result.addActions(issueDto.getKey(), this.listAvailableActions(issueDto, project));
                }
                if (!fields.contains((Object)SearchAdditionalField.TRANSITIONS) || issueDto.isExternal()) continue;
                DefaultIssue issue = issueDto.toDefaultIssue();
                result.addTransitions(issue.key(), this.transitionService.listTransitions(issue));
            }
        }
    }

    private Set<String> listAvailableActions(IssueDto issue, ComponentDto project) {
        HashSet availableActions = Sets.newHashSet();
        String login = this.userSession.getLogin();
        if (login == null) {
            return Collections.emptySet();
        }
        RuleType ruleType = RuleType.valueOf((int)issue.getType());
        availableActions.add("comment");
        if (issue.getResolution() != null) {
            return availableActions;
        }
        availableActions.add("assign");
        availableActions.add("set_tags");
        if (!issue.isFromHotspot() && this.userSession.hasComponentPermission("issueadmin", project)) {
            availableActions.add("set_type");
        }
        if (ruleType != RuleType.SECURITY_HOTSPOT && this.userSession.hasComponentPermission("issueadmin", project)) {
            availableActions.add("set_severity");
        }
        return availableActions;
    }

    private static void completeTotalEffortFromFacet(@Nullable Facets facets, SearchResponseData result) {
        LinkedHashMap effortFacet;
        if (facets != null && (effortFacet = facets.get("effort")) != null) {
            result.setEffortTotal((Long)effortFacet.get("total"));
        }
    }

    private static class KeyToIssueFunction
    implements Function<String, IssueDto> {
        private final Map<String, IssueDto> map = new HashMap<String, IssueDto>();

        private KeyToIssueFunction(Collection<IssueDto> unordered) {
            for (IssueDto dto : unordered) {
                this.map.put(dto.getKey(), dto);
            }
        }

        @Nullable
        public IssueDto apply(String issueKey) {
            return this.map.get(issueKey);
        }
    }

    public static class Collector {
        private final Set<String> componentUuids = new HashSet<String>();
        private final Set<String> projectUuids = new HashSet<String>();
        private final List<String> issueKeys;
        private final Set<Integer> ruleIds = new HashSet<Integer>();
        private final Set<String> userUuids = new HashSet<String>();

        public Collector(List<String> issueKeys) {
            this.issueKeys = issueKeys;
        }

        void collect(List<IssueDto> issues) {
            for (IssueDto issue : issues) {
                this.componentUuids.add(issue.getComponentUuid());
                this.projectUuids.add(issue.getProjectUuid());
                this.ruleIds.add(issue.getRuleId());
                String issueAssigneeUuid = issue.getAssigneeUuid();
                if (issueAssigneeUuid != null) {
                    this.userUuids.add(issueAssigneeUuid);
                }
                this.collectComponentsFromIssueLocations(issue);
            }
        }

        private void collectComponentsFromIssueLocations(IssueDto issue) {
            DbIssues.Locations locations = issue.parseLocations();
            if (locations != null) {
                for (DbIssues.Flow flow : locations.getFlowList()) {
                    for (DbIssues.Location location : flow.getLocationList()) {
                        if (!location.hasComponentId()) continue;
                        this.componentUuids.add(location.getComponentId());
                    }
                }
            }
        }

        void addComponentUuids(@Nullable Collection<String> uuids) {
            if (uuids != null) {
                this.componentUuids.addAll(uuids);
            }
        }

        void addProjectUuid(String uuid) {
            this.projectUuids.add(uuid);
        }

        void addProjectUuids(@Nullable Collection<String> uuids) {
            if (uuids != null) {
                this.projectUuids.addAll(uuids);
            }
        }

        void addRuleIds(@Nullable Collection<String> ruleIds) {
            if (ruleIds != null) {
                this.ruleIds.addAll((Collection)ruleIds.stream().map(Integer::parseInt).collect(MoreCollectors.toList()));
            }
        }

        void addUserUuids(@Nullable Collection<String> userUuids) {
            if (userUuids != null) {
                this.userUuids.addAll(userUuids);
            }
        }

        public List<String> getIssueKeys() {
            return this.issueKeys;
        }

        public Set<String> getComponentUuids() {
            return this.componentUuids;
        }

        public Set<String> getProjectUuids() {
            return this.projectUuids;
        }

        public Set<Integer> getRuleIds() {
            return this.ruleIds;
        }

        Set<String> getUserUuids() {
            return this.userUuids;
        }
    }
}

