/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.dbutils.DbUtils;
import org.picocontainer.Startable;
import org.sonar.api.SonarRuntime;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.DdlUtils;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.DefaultServerUpgradeStatus;
import org.sonar.server.platform.db.migration.engine.MigrationEngine;
import org.sonar.server.platform.db.migration.step.MigrationSteps;

public class AutoDbMigration
implements Startable {
    private final DefaultServerUpgradeStatus serverUpgradeStatus;
    private final DbClient dbClient;
    private final MigrationEngine migrationEngine;
    private final MigrationSteps migrationSteps;
    private final SonarRuntime sonarRuntime;
    private final System2 system2;

    public AutoDbMigration(DefaultServerUpgradeStatus serverUpgradeStatus, DbClient dbClient, MigrationEngine migrationEngine, MigrationSteps migrationSteps, SonarRuntime sonarRuntime, System2 system2) {
        this.serverUpgradeStatus = serverUpgradeStatus;
        this.dbClient = dbClient;
        this.migrationEngine = migrationEngine;
        this.migrationSteps = migrationSteps;
        this.sonarRuntime = sonarRuntime;
        this.system2 = system2;
    }

    private static void populateSchemaMigration(Connection connection, long maxMigrationNumber) {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO SCHEMA_MIGRATIONS(VERSION) VALUES (?)");){
            AutoDbMigration.batchExecute(0L, maxMigrationNumber + 1L, preparedStatement, connection, (statement, counter) -> statement.setString(1, String.valueOf(counter)));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to insert rows into table SCHEMA_MIGRATIONS", e);
        }
    }

    private static void hackFixForProjectMeasureTreeQueries(Connection connection) {
        int metricId = 1;
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into PROJECT_MEASURES (METRIC_ID,COMPONENT_UUID,ANALYSIS_UUID) values (?,?,?);");){
            AutoDbMigration.batchExecute(1L, 1000L, preparedStatement, connection, (stmt, counter) -> {
                preparedStatement.setInt(1, metricId);
                preparedStatement.setString(2, "foo_" + counter);
                preparedStatement.setString(3, "bar_" + counter);
            });
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to insert fake rows into table PROJECT_MEASURES", e);
        }
    }

    private static void batchExecute(long start, long end, PreparedStatement preparedStatement, Connection connection, Preparer preparer) throws SQLException {
        for (long i = start; i < end; ++i) {
            preparer.prepare(preparedStatement, i);
            preparedStatement.addBatch();
            if (i % 250L != 0L) continue;
            preparedStatement.executeBatch();
            connection.commit();
        }
        preparedStatement.executeBatch();
        connection.commit();
    }

    public void start() {
        if (this.serverUpgradeStatus.isFreshInstall()) {
            Loggers.get(this.getClass()).info("Automatically perform DB migration on fresh install");
            Dialect dialect = this.dbClient.getDatabase().getDialect();
            if ("h2".equals(dialect.getId())) {
                this.installH2();
            } else {
                this.migrationEngine.execute();
            }
        } else if (this.serverUpgradeStatus.isUpgraded() && this.serverUpgradeStatus.isBlueGreen()) {
            Loggers.get(this.getClass()).info("Automatically perform DB migration on blue/green deployment");
            this.migrationEngine.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void installH2() {
        Connection connection = null;
        try (DbSession session = this.dbClient.openSession(false);){
            connection = session.getConnection();
            this.createH2Schema(connection, this.dbClient.getDatabase().getDialect().getId());
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(connection);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)connection);
    }

    @VisibleForTesting
    protected void createH2Schema(Connection connection, String dialectId) {
        DdlUtils.createSchema((Connection)connection, (String)dialectId, (boolean)false);
        this.populateInstallDateAndVersion(connection);
        AutoDbMigration.populateSchemaMigration(connection, this.migrationSteps.getMaxMigrationNumber());
        AutoDbMigration.hackFixForProjectMeasureTreeQueries(connection);
    }

    private void populateInstallDateAndVersion(Connection connection) {
        this.insertInternalProperty(connection, "installation.date", String.valueOf(this.system2.now()));
        this.insertInternalProperty(connection, "installation.version", this.sonarRuntime.getApiVersion().toString());
    }

    private void insertInternalProperty(Connection connection, String key, String value) {
        try (PreparedStatement preparedStatementDate = connection.prepareStatement("insert into internal_properties (kee, is_empty, text_value, clob_value, created_at) values (?, ?, ?, ?, ?)");){
            preparedStatementDate.setString(1, key);
            preparedStatementDate.setBoolean(2, false);
            preparedStatementDate.setString(3, value);
            preparedStatementDate.setString(4, null);
            preparedStatementDate.setLong(5, this.system2.now());
            preparedStatementDate.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to insert internal properties " + key, e);
        }
    }

    public void stop() {
    }

    @FunctionalInterface
    private static interface Preparer {
        public void prepare(PreparedStatement var1, long var2) throws SQLException;
    }
}

