/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring.cluster;

import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.sonar.api.server.ServerSide;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.es.EsClient;
import org.sonar.server.platform.monitoring.EsStateSection;
import org.sonar.server.platform.monitoring.cluster.NodeInfo;
import org.sonar.server.platform.monitoring.cluster.SearchNodesInfoLoader;

@ServerSide
public class SearchNodesInfoLoaderImpl
implements SearchNodesInfoLoader {
    private final EsClient esClient;

    public SearchNodesInfoLoaderImpl(EsClient esClient) {
        this.esClient = esClient;
    }

    @Override
    public Collection<NodeInfo> load() {
        NodesStatsResponse nodesStats = (NodesStatsResponse)this.esClient.prepareNodesStats(new String[0]).setFs(true).setProcess(true).setJvm(true).setIndices(true).setBreaker(true).get();
        ArrayList<NodeInfo> result = new ArrayList<NodeInfo>();
        nodesStats.getNodes().forEach(nodeStat -> result.add(SearchNodesInfoLoaderImpl.toNodeInfo(nodeStat)));
        return result;
    }

    private static NodeInfo toNodeInfo(NodeStats stat) {
        String nodeName = stat.getNode().getName();
        NodeInfo info = new NodeInfo(nodeName);
        info.setHost(stat.getHostname());
        ProtobufSystemInfo.Section.Builder section = ProtobufSystemInfo.Section.newBuilder();
        section.setName("Search State");
        EsStateSection.toProtobuf(stat, section);
        info.addSection(section.build());
        return info;
    }
}

