/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.measure.index.ProjectMeasuresIndex;
import org.sonar.server.measure.index.ProjectMeasuresQuery;
import org.sonar.server.qualitygate.ProjectsInWarning;
import org.sonar.server.util.GlobalLockManager;

public class ProjectsInWarningDaemon
implements Startable {
    static final String PROJECTS_IN_WARNING_INTERNAL_PROPERTY = "projectsInWarning";
    private static final Logger LOG = Loggers.get(ProjectsInWarningDaemon.class);
    private static final String FREQUENCY_IN_MILLISECONDS_PROPERTY = "sonar.projectsInWarning.frequencyInMilliseconds";
    private static final int DEFAULT_FREQUENCY_IN_MILLISECONDS = 86400000;
    private static final String THREAD_NAME_PREFIX = "sq-projects-in-warning-service-";
    private static final String LOCK_NAME = "ProjectsInWarn";
    private static final int LOCK_DURATION_IN_SECOND = 3600;
    private final DbClient dbClient;
    private final ProjectMeasuresIndex projectMeasuresIndex;
    private final Configuration config;
    private final GlobalLockManager lockManager;
    private final ProjectsInWarning projectsInWarning;
    private ScheduledExecutorService executorService;

    public ProjectsInWarningDaemon(DbClient dbClient, ProjectMeasuresIndex projectMeasuresIndex, Configuration config, GlobalLockManager lockManager, ProjectsInWarning projectsInWarning) {
        this.dbClient = dbClient;
        this.projectMeasuresIndex = projectMeasuresIndex;
        this.config = config;
        this.lockManager = lockManager;
        this.projectsInWarning = projectsInWarning;
    }

    public void notifyStart() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional internalProperty = this.dbClient.internalPropertiesDao().selectByKey(dbSession, PROJECTS_IN_WARNING_INTERNAL_PROPERTY);
            if (internalProperty.isPresent() && ((String)internalProperty.get()).equals("0")) {
                this.projectsInWarning.update(0L);
                LOG.info("Counting number of projects in warning is not started as there are no projects in this situation.");
                return;
            }
        }
        LOG.info("Counting number of projects in warning is enabled.");
        this.executorService = Executors.newSingleThreadScheduledExecutor(ProjectsInWarningDaemon.newThreadFactory());
        this.executorService.scheduleWithFixedDelay(this.countProjectsInWarning(), 0L, this.frequency(), TimeUnit.MILLISECONDS);
    }

    private int frequency() {
        return this.config.getInt(FREQUENCY_IN_MILLISECONDS_PROPERTY).orElse(86400000);
    }

    private Runnable countProjectsInWarning() {
        return () -> {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                long nbProjectsInWarning = this.projectMeasuresIndex.search(new ProjectMeasuresQuery().setQualityGateStatus(Metric.Level.WARN).setIgnoreAuthorization(true), new SearchOptions().setLimit(1)).getTotal();
                this.projectsInWarning.update(nbProjectsInWarning);
                this.updateProjectsInWarningInDb(dbSession, nbProjectsInWarning);
                if (nbProjectsInWarning == 0L) {
                    LOG.info("Counting number of projects in warning will be disabled as there are no more projects in warning.");
                    this.executorService.shutdown();
                }
            }
            catch (Exception e) {
                LOG.error("Error while counting number of projects in warning: {}", (Throwable)e);
            }
        };
    }

    private void updateProjectsInWarningInDb(DbSession dbSession, long nbProjectsInWarning) {
        if (!this.lockManager.tryLock(LOCK_NAME, 3600)) {
            return;
        }
        this.dbClient.internalPropertiesDao().save(dbSession, PROJECTS_IN_WARNING_INTERNAL_PROPERTY, Long.toString(nbProjectsInWarning));
        dbSession.commit();
    }

    public void start() {
    }

    public void stop() {
        if (this.executorService == null) {
            return;
        }
        try {
            this.executorService.shutdown();
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static ThreadFactory newThreadFactory() {
        return new ThreadFactoryBuilder().setNameFormat("sq-projects-in-warning-service-%d").setPriority(1).build();
    }
}

