/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.db.source.FileSourceDto;
import org.sonar.server.source.HtmlSourceDecorator;

public class SourceService {
    private final DbClient dbClient;
    private final HtmlSourceDecorator htmlDecorator;
    private final Function<DbFileSources.Line, String> lineToHtml;

    public SourceService(DbClient dbClient, HtmlSourceDecorator htmlDecorator) {
        this.dbClient = dbClient;
        this.htmlDecorator = htmlDecorator;
        this.lineToHtml = this.lineToHtml();
    }

    public Optional<Iterable<DbFileSources.Line>> getLines(DbSession dbSession, String fileUuid, int from, int toInclusive) {
        return this.getLines(dbSession, fileUuid, from, toInclusive, Function.identity());
    }

    public Optional<Iterable<DbFileSources.Line>> getLines(DbSession dbSession, String fileUuid, Set<Integer> lines) {
        return this.getLines(dbSession, fileUuid, lines, Function.identity());
    }

    public Optional<Iterable<String>> getLinesAsRawText(DbSession dbSession, String fileUuid, int from, int toInclusive) {
        return this.getLines(dbSession, fileUuid, from, toInclusive, DbFileSources.Line::getSource);
    }

    public Optional<Iterable<String>> getLinesAsHtml(DbSession dbSession, String fileUuid, int from, int toInclusive) {
        return this.getLines(dbSession, fileUuid, from, toInclusive, this.lineToHtml);
    }

    private <E> Optional<Iterable<E>> getLines(DbSession dbSession, String fileUuid, int from, int toInclusive, Function<DbFileSources.Line, E> function) {
        SourceService.verifyLine(from);
        Preconditions.checkArgument((toInclusive >= from ? 1 : 0) != 0, (Object)String.format("Line number must greater than or equal to %d, got %d", from, toInclusive));
        FileSourceDto dto = this.dbClient.fileSourceDao().selectByFileUuid(dbSession, fileUuid);
        if (dto == null) {
            return Optional.empty();
        }
        return Optional.of((Iterable)dto.getSourceData().getLinesList().stream().filter(line -> line.hasLine() && line.getLine() >= from).limit((long)(toInclusive - from) + 1L).map(function).collect(MoreCollectors.toList()));
    }

    private <E> Optional<Iterable<E>> getLines(DbSession dbSession, String fileUuid, Set<Integer> lines, Function<DbFileSources.Line, E> function) {
        FileSourceDto dto = this.dbClient.fileSourceDao().selectByFileUuid(dbSession, fileUuid);
        if (dto == null) {
            return Optional.empty();
        }
        return Optional.of((Iterable)dto.getSourceData().getLinesList().stream().filter(line -> line.hasLine() && lines.contains(line.getLine())).map(function).collect(MoreCollectors.toList()));
    }

    private static void verifyLine(int line) {
        Preconditions.checkArgument((line >= 1 ? 1 : 0) != 0, (Object)String.format("Line number must start at 1, got %d", line));
    }

    private Function<DbFileSources.Line, String> lineToHtml() {
        return line -> this.htmlDecorator.getDecoratedSourceAsHtml(line.getSource(), line.getHighlighting(), line.getSymbols());
    }
}

