/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.telemetry;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.ProcessProperties;

@ServerSide
public class TelemetryClient
implements Startable {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Logger LOG = Loggers.get(TelemetryClient.class);
    private final OkHttpClient okHttpClient;
    private final Configuration config;
    private String serverUrl;

    public TelemetryClient(OkHttpClient okHttpClient, Configuration config) {
        this.okHttpClient = okHttpClient;
        this.config = config;
    }

    void upload(String json) throws IOException {
        Request request = this.buildHttpRequest(json);
        TelemetryClient.execute(this.okHttpClient.newCall(request));
    }

    void optOut(String json) {
        Request.Builder request = new Request.Builder();
        request.url(this.serverUrl);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        request.delete(body);
        try {
            TelemetryClient.execute(this.okHttpClient.newCall(request.build()));
        }
        catch (IOException e) {
            LOG.debug("Error when sending opt-out usage statistics: {}", (Object)e.getMessage());
        }
    }

    private Request buildHttpRequest(String json) {
        Request.Builder request = new Request.Builder();
        request.url(this.serverUrl);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        request.post(body);
        return request.build();
    }

    private static void execute(Call call) throws IOException {
        Response ignored = call.execute();
        if (ignored != null) {
            ignored.close();
        }
    }

    public void start() {
        this.serverUrl = (String)this.config.get(ProcessProperties.Property.SONAR_TELEMETRY_URL.getKey()).orElseThrow(() -> new IllegalStateException(String.format("Setting '%s' must be provided.", ProcessProperties.Property.SONAR_TELEMETRY_URL)));
    }

    public void stop() {
    }
}

