/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.webhook.WebhookDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.UserSession;
import org.sonar.server.webhook.ws.WebhookSupport;
import org.sonar.server.webhook.ws.WebhooksWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Webhooks;

public class CreateAction
implements WebhooksWsAction {
    private static final int MAX_NUMBER_OF_WEBHOOKS = 10;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final UuidFactory uuidFactory;
    private final WebhookSupport webhookSupport;

    public CreateAction(DbClient dbClient, UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider, UuidFactory uuidFactory, WebhookSupport webhookSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.uuidFactory = uuidFactory;
        this.webhookSupport = webhookSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("create").setPost(true).setDescription("Create a Webhook.<br>Requires 'Administer' permission on the specified project, or global 'Administer' permission.").setSince("7.1").setResponseExample(this.getClass().getResource("example-webhook-create.json")).setHandler((RequestHandler)this);
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(100)).setDescription("Name displayed in the administration console of webhooks").setExampleValue((Object)"My Webhook");
        action.createParam("url").setRequired(true).setMaximumLength(Integer.valueOf(512)).setDescription("Server endpoint that will receive the webhook payload, for example 'http://my_server/foo'. If HTTP Basic authentication is used, HTTPS is recommended to avoid man in the middle attacks. Example: 'https://myLogin:myPassword@my_server/foo'").setExampleValue((Object)"https://www.my-webhook-listener.com/sonar");
        action.createParam("project").setRequired(false).setMaximumLength(Integer.valueOf(100)).setDescription("The key of the project that will own the webhook").setExampleValue((Object)"my_project");
        action.createParam("organization").setInternal(true).setRequired(false).setMaximumLength(Integer.valueOf(255)).setDescription("The key of the organization that will own the webhook").setExampleValue((Object)"my-org");
        action.createParam("secret").setRequired(false).setMinimumLength(Integer.valueOf(1)).setMaximumLength(Integer.valueOf(200)).setDescription("If provided, secret will be used as the key to generate the HMAC hex (lowercase) digest value in the 'X-Sonar-Webhook-HMAC-SHA256' header").setExampleValue((Object)"your_secret").setSince("7.8");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String name = request.mandatoryParam("name");
        String url = request.mandatoryParam("url");
        String projectKey = request.param("project");
        String organizationKey = request.param("organization");
        String secret = request.param("secret");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organizationDto;
            if (StringUtils.isNotBlank((String)organizationKey)) {
                Optional dtoOptional = this.dbClient.organizationDao().selectByKey(dbSession, organizationKey);
                organizationDto = (OrganizationDto)WsUtils.checkFoundWithOptional(dtoOptional, "No organization with key '%s'", organizationKey);
            } else {
                organizationDto = this.defaultOrganizationDto(dbSession);
            }
            ComponentDto projectDto = null;
            if (StringUtils.isNotBlank((String)projectKey)) {
                Optional dtoOptional = this.dbClient.componentDao().selectByKey(dbSession, projectKey);
                ComponentDto componentDto = (ComponentDto)WsUtils.checkFoundWithOptional(dtoOptional, "No project with key '%s'", projectKey);
                this.webhookSupport.checkThatProjectBelongsToOrganization(componentDto, organizationDto, "Project '%s' does not belong to organisation '%s'", projectKey, organizationKey);
                this.webhookSupport.checkPermission(componentDto);
                projectDto = componentDto;
            } else {
                this.webhookSupport.checkPermission(organizationDto);
            }
            this.webhookSupport.checkUrlPattern(url, "Url parameter with value '%s' is not a valid url", url);
            WebhookDto dto = this.doHandle(dbSession, organizationDto, projectDto, name, url, secret);
            this.dbClient.webhookDao().insert(dbSession, dto);
            dbSession.commit();
            CreateAction.writeResponse(request, response, dto);
        }
    }

    private WebhookDto doHandle(DbSession dbSession, @Nullable OrganizationDto organization, @Nullable ComponentDto project, String name, String url, @Nullable String secret) {
        Preconditions.checkState((organization != null || project != null ? 1 : 0) != 0, (Object)"A webhook can not be created if not linked to an organization or a project.");
        WebhookDto dto = new WebhookDto().setUuid(this.uuidFactory.create()).setName(name).setUrl(url).setSecret(secret);
        if (project != null) {
            CreateAction.checkNumberOfWebhook(this.numberOfWebhookOf(dbSession, project), "Maximum number of webhook reached for project '%s'", project.getKey());
            dto.setProjectUuid(project.projectUuid());
        } else {
            CreateAction.checkNumberOfWebhook(this.numberOfWebhookOf(dbSession, organization), "Maximum number of webhook reached for organization '%s'", organization.getKey());
            dto.setOrganizationUuid(organization.getUuid());
        }
        return dto;
    }

    private static void writeResponse(Request request, Response response, WebhookDto dto) {
        Webhooks.CreateWsResponse.Webhook.Builder webhookBuilder = Webhooks.CreateWsResponse.Webhook.newBuilder();
        webhookBuilder.setKey(dto.getUuid()).setName(dto.getName()).setUrl(dto.getUrl());
        if (dto.getSecret() != null) {
            webhookBuilder.setSecret(dto.getSecret());
        }
        WsUtils.writeProtobuf((Message)Webhooks.CreateWsResponse.newBuilder().setWebhook(webhookBuilder).build(), request, response);
    }

    private static void checkNumberOfWebhook(int nbOfWebhooks, String message, Object ... messageArguments) {
        if (nbOfWebhooks >= 10) {
            throw new IllegalArgumentException(String.format(message, messageArguments));
        }
    }

    private int numberOfWebhookOf(DbSession dbSession, OrganizationDto organizationDto) {
        return this.dbClient.webhookDao().selectByOrganization(dbSession, organizationDto).size();
    }

    private int numberOfWebhookOf(DbSession dbSession, ComponentDto componentDto) {
        return this.dbClient.webhookDao().selectByProject(dbSession, componentDto).size();
    }

    private OrganizationDto defaultOrganizationDto(DbSession dbSession) {
        String uuid = this.defaultOrganizationProvider.get().getUuid();
        Optional organizationDto = this.dbClient.organizationDao().selectByUuid(dbSession, uuid);
        return (OrganizationDto)WsUtils.checkStateWithOptional(organizationDto, "the default organization '%s' was not found", uuid);
    }
}

