/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.dependencies;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="IllegalNamespaceCheck")
public class IllegalNamespaceCheck
extends AbstractPageCheck {
    private static final String DEFAULT_NAMESPACES = "";
    @RuleProperty(key="namespaces", description="Comma separated list of namespaces", defaultValue="")
    public String namespaces = "";
    private String[] namespacesArray;

    @Override
    public void startDocument(List<Node> nodes) {
        this.namespacesArray = StringUtils.split(this.namespaces, ",");
    }

    @Override
    public void startElement(TagNode element) {
        for (Attribute a : element.getAttributes()) {
            if (!StringUtils.startsWithIgnoreCase(a.getName(), "xmlns")) continue;
            for (String namespace : this.namespacesArray) {
                if (!a.getValue().equalsIgnoreCase(namespace)) continue;
                this.createViolation(element.getStartLinePosition(), "Using \"" + a.getValue() + "\" namespace is not allowed.");
            }
        }
    }
}

