/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="FieldsetWithoutLegendCheck")
public class FieldsetWithoutLegendCheck
extends AbstractPageCheck {
    private int fieldsetLine = 0;
    private boolean foundLegend;

    @Override
    public void startElement(TagNode node) {
        if (FieldsetWithoutLegendCheck.isFieldSet(node)) {
            this.foundLegend = false;
            this.fieldsetLine = node.getStartLinePosition();
        } else if (FieldsetWithoutLegendCheck.isLegend(node)) {
            this.foundLegend = true;
        }
    }

    @Override
    public void endElement(TagNode node) {
        if (FieldsetWithoutLegendCheck.isFieldSet(node)) {
            if (!this.foundLegend && this.fieldsetLine != 0) {
                this.createViolation(this.fieldsetLine, "Add a <legend> tag to this fieldset.");
            }
            this.foundLegend = false;
            this.fieldsetLine = 0;
        }
    }

    private static boolean isFieldSet(TagNode node) {
        return "FIELDSET".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isLegend(TagNode node) {
        return "LEGEND".equalsIgnoreCase(node.getNodeName());
    }
}

