/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.lex;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.channel.CodeReader;
import org.sonar.channel.EndMatcher;
import org.sonar.plugins.html.lex.AbstractTokenizer;
import org.sonar.plugins.html.lex.PageLexer;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

class ElementTokenizer
extends AbstractTokenizer<List<Node>> {
    private static EndQNameMatcher endQNameMatcher = new EndQNameMatcher();
    private static EndTokenMatcher endTokenMatcher = new EndTokenMatcher();
    private static EndUnquotedAttributeMatcher endUnquotedAttributeMatcher = new EndUnquotedAttributeMatcher();

    public ElementTokenizer(String startToken, String endToken) {
        super(startToken, endToken);
    }

    @Override
    protected void addNode(List<Node> nodeList, Node node) {
        super.addNode(nodeList, node);
        this.parseToken(node);
    }

    @Override
    Node createNode() {
        return new TagNode();
    }

    private void parseToken(Node node) {
        TagNode element = (TagNode)node;
        CodeReader codeReader = new CodeReader(node.getCode());
        ParseMode mode = ParseMode.BEFORE_NODE_NAME;
        int ch = codeReader.peek();
        while (ch != -1) {
            if (Character.isWhitespace(ch)) {
                codeReader.pop();
            } else {
                switch (ch) {
                    case 61: {
                        mode = ParseMode.BEFORE_ATTRIBUTE_VALUE;
                        codeReader.pop();
                        break;
                    }
                    case 60: {
                        ElementTokenizer.nestedTag(element, codeReader, mode);
                        break;
                    }
                    case 37: 
                    case 47: 
                    case 62: 
                    case 64: {
                        codeReader.pop();
                        break;
                    }
                    default: {
                        mode = this.parseToken(mode, codeReader, element);
                    }
                }
            }
            ch = codeReader.peek();
        }
    }

    private static void nestedTag(TagNode element, CodeReader codeReader, ParseMode mode) {
        if (mode == ParseMode.BEFORE_ATTRIBUTE_NAME) {
            ElementTokenizer.parseNestedTag(codeReader, element);
        } else {
            codeReader.pop();
        }
    }

    private static void parseNestedTag(CodeReader codeReader, TagNode element) {
        PageLexer nestedPageLexer = new PageLexer();
        List<Node> nodeList = nestedPageLexer.nestedParse(codeReader);
        for (Node node : nodeList) {
            element.getAttributes().add(new Attribute(node.getCode()));
        }
    }

    private ParseMode parseToken(ParseMode mode, CodeReader codeReader, TagNode element) {
        switch (mode) {
            case BEFORE_NODE_NAME: {
                ElementTokenizer.handleBeforeNodeName(codeReader, element);
                return ParseMode.BEFORE_ATTRIBUTE_NAME;
            }
            case BEFORE_ATTRIBUTE_NAME: {
                ElementTokenizer.handleBeforeAttributeName(codeReader, element);
                return ParseMode.BEFORE_ATTRIBUTE_NAME;
            }
            case BEFORE_ATTRIBUTE_VALUE: {
                ElementTokenizer.handleBeforeAttributeValue(codeReader, element);
                return ParseMode.BEFORE_ATTRIBUTE_NAME;
            }
        }
        return ParseMode.BEFORE_NODE_NAME;
    }

    private static void handleBeforeAttributeValue(CodeReader codeReader, TagNode element) {
        if (!element.getAttributes().isEmpty()) {
            Attribute attribute = element.getAttributes().get(element.getAttributes().size() - 1);
            StringBuilder sbValue = new StringBuilder();
            int ch = codeReader.peek();
            if (ElementTokenizer.isQuote((char)ch)) {
                codeReader.pop();
                if (codeReader.peek() != ch) {
                    QuoteMatcher quoteMatcher = new QuoteMatcher((char)ch);
                    quoteMatcher.match(codeReader.peek());
                    codeReader.popTo(quoteMatcher, (Appendable)sbValue);
                    attribute.setValue(ElementTokenizer.unescapeQuotes(sbValue.toString(), (char)ch));
                }
                codeReader.pop();
                attribute.setQuoteChar((char)ch);
            } else {
                codeReader.popTo(endUnquotedAttributeMatcher, (Appendable)sbValue);
                attribute.setValue(sbValue.toString().trim());
            }
        }
    }

    private static void handleBeforeAttributeName(CodeReader codeReader, TagNode element) {
        StringBuilder sbQName = new StringBuilder();
        codeReader.popTo(endQNameMatcher, (Appendable)sbQName);
        Attribute attribute = new Attribute(sbQName.toString().trim());
        attribute.setLine(codeReader.getLinePosition() + element.getStartLinePosition() - 1);
        element.getAttributes().add(attribute);
    }

    private static void handleBeforeNodeName(CodeReader codeReader, TagNode element) {
        StringBuilder sbNodeName = new StringBuilder();
        codeReader.popTo(endTokenMatcher, (Appendable)sbNodeName);
        element.setNodeName(sbNodeName.toString());
    }

    private static String unescapeQuotes(String value, char ch) {
        return StringUtils.replace(value, "\\" + ch, Character.toString(ch));
    }

    private static boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    private static final class QuoteMatcher
    implements EndMatcher {
        private static final char SINGLE_QUOTE = '\'';
        private static final char DOUBLE_QUOTE = '\"';
        private int previousChar;
        private final Deque<Character> startChars = new ArrayDeque<Character>();

        QuoteMatcher(char startChar) {
            this.startChars.addFirst(Character.valueOf(startChar));
        }

        @Override
        public boolean match(int character) {
            boolean result = false;
            if ((character == 39 || character == 34) && this.previousChar != 92) {
                if (this.startChars.peekFirst().charValue() == (char)character) {
                    this.startChars.removeFirst();
                } else {
                    this.startChars.addFirst(Character.valueOf((char)character));
                }
                result = this.startChars.isEmpty();
            }
            this.previousChar = character;
            return result;
        }
    }

    private static enum ParseMode {
        BEFORE_ATTRIBUTE_NAME,
        BEFORE_ATTRIBUTE_VALUE,
        BEFORE_NODE_NAME;

    }

    private static final class EndTokenMatcher
    implements EndMatcher {
        private EndTokenMatcher() {
        }

        @Override
        public boolean match(int character) {
            switch (character) {
                case 47: 
                case 62: {
                    return true;
                }
            }
            return Character.isWhitespace(character);
        }
    }

    private static final class EndUnquotedAttributeMatcher
    implements EndMatcher {
        private static final Set<Character> FORBIDDEN = ImmutableSet.of(Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('='), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('`'), new Character[0]);

        private EndUnquotedAttributeMatcher() {
        }

        @Override
        public boolean match(int character) {
            return Character.isWhitespace(character) || FORBIDDEN.contains(Character.valueOf((char)character));
        }
    }

    private static final class EndQNameMatcher
    implements EndMatcher {
        private EndQNameMatcher() {
        }

        @Override
        public boolean match(int character) {
            return character == 61 || character == 62 || Character.isWhitespace(character);
        }
    }
}

