/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.api.posttask;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonar.api.ce.posttask.QualityGate;
import org.sonar.ce.task.projectanalysis.api.posttask.ConditionImpl;
import org.sonar.ce.task.projectanalysis.qualitygate.Condition;
import org.sonar.ce.task.projectanalysis.qualitygate.ConditionStatus;

class ConditionToCondition
implements Function<Condition, QualityGate.Condition> {
    private final ConditionImpl.Builder builder = ConditionImpl.newBuilder();
    private final Map<Condition, ConditionStatus> statusPerConditions;

    public ConditionToCondition(Map<Condition, ConditionStatus> statusPerConditions) {
        this.statusPerConditions = statusPerConditions;
    }

    @Nonnull
    public QualityGate.Condition apply(Condition input) {
        String metricKey = input.getMetric().getKey();
        ConditionStatus conditionStatus = this.statusPerConditions.get(input);
        Preconditions.checkState((conditionStatus != null ? 1 : 0) != 0, (String)"Missing ConditionStatus for condition on metric key %s", (Object[])new Object[]{metricKey});
        return this.builder.setStatus(ConditionToCondition.convert(conditionStatus.getStatus())).setMetricKey(metricKey).setOperator(ConditionToCondition.convert(input.getOperator())).setErrorThreshold(input.getErrorThreshold()).setValue(conditionStatus.getValue()).build();
    }

    private static QualityGate.EvaluationStatus convert(ConditionStatus.EvaluationStatus status) {
        switch (status) {
            case NO_VALUE: {
                return QualityGate.EvaluationStatus.NO_VALUE;
            }
            case OK: {
                return QualityGate.EvaluationStatus.OK;
            }
            case ERROR: {
                return QualityGate.EvaluationStatus.ERROR;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported value '%s' of ConditionStatus.EvaluationStatus can not be converted to QualityGate.EvaluationStatus", new Object[]{status}));
    }

    private static QualityGate.Operator convert(Condition.Operator operator) {
        switch (operator) {
            case GREATER_THAN: {
                return QualityGate.Operator.GREATER_THAN;
            }
            case LESS_THAN: {
                return QualityGate.Operator.LESS_THAN;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported value '%s' of Condition.Operation can not be converted to QualityGate.Operator", new Object[]{operator}));
    }
}

