/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.filemove;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.filemove.MutableAddedFileRepository;

public class AddedFileRepositoryImpl
implements MutableAddedFileRepository {
    private final Set<Component> addedComponents = new HashSet<Component>();
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public AddedFileRepositoryImpl(AnalysisMetadataHolder analysisMetadataHolder) {
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public boolean isAdded(Component component) {
        AddedFileRepositoryImpl.checkComponent(component);
        if (this.analysisMetadataHolder.isFirstAnalysis()) {
            return true;
        }
        return this.addedComponents.contains(component);
    }

    @Override
    public void register(Component component) {
        AddedFileRepositoryImpl.checkComponent(component);
        Preconditions.checkArgument((component.getType() == Component.Type.FILE ? 1 : 0) != 0, (Object)"component must be a file");
        Preconditions.checkState((!this.analysisMetadataHolder.isFirstAnalysis() ? 1 : 0) != 0, (Object)"No file can be registered on first analysis");
        this.addedComponents.add(component);
    }

    private static void checkComponent(Component component) {
        Preconditions.checkNotNull((Object)component, (Object)"component can't be null");
    }
}

