/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.filemove;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.ce.task.projectanalysis.filemove.MutableMovedFilesRepository;

public class MutableMovedFilesRepositoryImpl
implements MutableMovedFilesRepository {
    private final Map<String, MovedFilesRepository.OriginalFile> originalFiles = new HashMap<String, MovedFilesRepository.OriginalFile>();

    @Override
    public void setOriginalFile(Component file, MovedFilesRepository.OriginalFile originalFile) {
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(originalFile, "originalFile can't be null");
        Preconditions.checkArgument((file.getType() == Component.Type.FILE ? 1 : 0) != 0, (Object)"file must be of type FILE");
        MovedFilesRepository.OriginalFile existingOriginalFile = this.originalFiles.get(file.getDbKey());
        Preconditions.checkState((existingOriginalFile == null || existingOriginalFile.equals(originalFile) ? 1 : 0) != 0, (String)"Original file %s already registered for file %s. Unable to register %s.", (Object[])new Object[]{existingOriginalFile, file, originalFile});
        if (existingOriginalFile == null) {
            this.originalFiles.put(file.getDbKey(), originalFile);
        }
    }

    @Override
    public Optional<MovedFilesRepository.OriginalFile> getOriginalFile(Component file) {
        Objects.requireNonNull(file, "file can't be null");
        if (file.getType() != Component.Type.FILE) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.originalFiles.get(file.getDbKey()));
    }
}

