/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.scm;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.ce.task.projectanalysis.scm.Changeset;
import org.sonar.ce.task.projectanalysis.scm.ScmInfo;
import org.sonar.ce.task.projectanalysis.scm.ScmInfoImpl;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.scanner.protocol.output.ScannerReport;

@Immutable
class ReportScmInfo
implements ScmInfo {
    private final ScmInfo delegate;

    ReportScmInfo(ScannerReport.Changesets changesets) {
        Objects.requireNonNull(changesets);
        this.delegate = ReportScmInfo.convertToScmInfo(changesets);
        Preconditions.checkState((!this.delegate.getAllChangesets().isEmpty() ? 1 : 0) != 0, (Object)"Report has no changesets");
    }

    private static ScmInfo convertToScmInfo(ScannerReport.Changesets changesets) {
        return new ScmInfoImpl(IntStream.rangeClosed(1, changesets.getChangesetIndexByLineCount()).boxed().collect(Collectors.toMap(x -> x, new LineIndexToChangeset(changesets), MoreCollectors.mergeNotSupportedMerger(), LinkedHashMap::new)));
    }

    @Override
    public Changeset getLatestChangeset() {
        return this.delegate.getLatestChangeset();
    }

    @Override
    public Changeset getChangesetForLine(int lineNumber) {
        return this.delegate.getChangesetForLine(lineNumber);
    }

    @Override
    public boolean hasChangesetForLine(int lineNumber) {
        return this.delegate.hasChangesetForLine(lineNumber);
    }

    @Override
    public Map<Integer, Changeset> getAllChangesets() {
        return this.delegate.getAllChangesets();
    }

    private static class LineIndexToChangeset
    implements Function<Integer, Changeset> {
        private final ScannerReport.Changesets changesets;
        private final Map<Integer, Changeset> changesetCache;
        private final Changeset.Builder builder = Changeset.newChangesetBuilder();

        public LineIndexToChangeset(ScannerReport.Changesets changesets) {
            this.changesets = changesets;
            this.changesetCache = new HashMap<Integer, Changeset>(changesets.getChangesetCount());
        }

        @Override
        public Changeset apply(Integer lineNumber) {
            int changesetIndex = this.changesets.getChangesetIndexByLine(lineNumber - 1);
            return this.changesetCache.computeIfAbsent(changesetIndex, idx -> this.convert(this.changesets.getChangeset(changesetIndex), lineNumber));
        }

        private Changeset convert(ScannerReport.Changesets.Changeset changeset, int line) {
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)changeset.getRevision()), (String)"Changeset on line %s must have a revision", (Object[])new Object[]{line});
            Preconditions.checkState((changeset.getDate() != 0L ? 1 : 0) != 0, (String)"Changeset on line %s must have a date", (Object[])new Object[]{line});
            return this.builder.setRevision(changeset.getRevision()).setAuthor(StringUtils.isNotEmpty((String)changeset.getAuthor()) ? changeset.getAuthor() : null).setDate(changeset.getDate()).build();
        }
    }
}

