/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.view.TriggerViewRefreshDelegate;
import org.sonar.ce.task.step.ComputationStep;

public class TriggerViewRefreshStep
implements ComputationStep {
    @Nullable
    private final TriggerViewRefreshDelegate triggerViewRefreshDelegate;
    private final AnalysisMetadataHolder analysisMetadata;

    public TriggerViewRefreshStep(AnalysisMetadataHolder analysisMetadata) {
        this.analysisMetadata = analysisMetadata;
        this.triggerViewRefreshDelegate = null;
    }

    public TriggerViewRefreshStep(AnalysisMetadataHolder analysisMetadata, @Nullable TriggerViewRefreshDelegate triggerViewRefreshDelegate) {
        this.analysisMetadata = analysisMetadata;
        this.triggerViewRefreshDelegate = triggerViewRefreshDelegate;
    }

    public String getDescription() {
        return "Trigger refresh of Portfolios and Applications";
    }

    public void execute(ComputationStep.Context context) {
        if (this.triggerViewRefreshDelegate != null) {
            OptionalInt count = this.triggerViewRefreshDelegate.triggerFrom(this.analysisMetadata.getProject());
            count.ifPresent(i -> context.getStatistics().add("refreshes", (Object)i));
        }
    }
}

