/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.charset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.version.SqTables;
import org.sonar.server.platform.db.migration.charset.SqlExecutor;

@Immutable
public class ColumnDef {
    public static final String SELECT_COLUMNS = "select table_name, column_name, character_set_name, collation_name, data_type, character_maximum_length, is_nullable ";
    private final String table;
    private final String column;
    private final String charset;
    private final String collation;
    private final String dataType;
    private final long size;
    private final boolean nullable;

    public ColumnDef(String table, String column, String charset, String collation, String dataType, long size, boolean nullable) {
        this.table = table;
        this.column = column;
        this.charset = charset;
        this.collation = collation;
        this.dataType = dataType;
        this.size = size;
        this.nullable = nullable;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollation() {
        return this.collation;
    }

    public String getDataType() {
        return this.dataType;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isInSonarQubeTable() {
        String tableName = this.table.toLowerCase(Locale.ENGLISH);
        return SqTables.TABLES.contains(tableName) || SqTables.OLD_DROPPED_TABLES.contains(tableName);
    }

    public static enum ColumnDefRowConverter implements SqlExecutor.RowConverter<ColumnDef>
    {
        INSTANCE;


        @Override
        public ColumnDef convert(ResultSet rs) throws SQLException {
            String nullableText = rs.getString(7);
            boolean nullable = "YES".equalsIgnoreCase(nullableText);
            return new ColumnDef(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getLong(6), nullable);
        }
    }
}

