/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.platform.db.migration.step.InternalMigrationStepRegistry;
import org.sonar.server.platform.db.migration.step.MigrationNumber;
import org.sonar.server.platform.db.migration.step.MigrationStep;
import org.sonar.server.platform.db.migration.step.MigrationStepRegistry;
import org.sonar.server.platform.db.migration.step.MigrationSteps;
import org.sonar.server.platform.db.migration.step.MigrationStepsImpl;
import org.sonar.server.platform.db.migration.step.RegisteredMigrationStep;

public class MigrationStepRegistryImpl
implements InternalMigrationStepRegistry {
    private final Map<Long, RegisteredMigrationStep> migrations = new HashMap<Long, RegisteredMigrationStep>();

    @Override
    public <T extends MigrationStep> MigrationStepRegistry add(long migrationNumber, String description, Class<T> stepClass) {
        MigrationNumber.validate(migrationNumber);
        Objects.requireNonNull(description, "description can't be null");
        Preconditions.checkArgument((!description.isEmpty() ? 1 : 0) != 0, (Object)"description can't be empty");
        Objects.requireNonNull(stepClass, "MigrationStep class can't be null");
        Preconditions.checkState((!this.migrations.containsKey(migrationNumber) ? 1 : 0) != 0, (String)"A migration is already registered for migration number '%s'", (Object[])new Object[]{migrationNumber});
        this.migrations.put(migrationNumber, new RegisteredMigrationStep(migrationNumber, description, stepClass));
        return this;
    }

    @Override
    public MigrationSteps build() {
        Preconditions.checkState((!this.migrations.isEmpty() ? 1 : 0) != 0, (Object)"Registry is empty");
        return new MigrationStepsImpl(MigrationStepRegistryImpl.toOrderedList(this.migrations));
    }

    private static List<RegisteredMigrationStep> toOrderedList(Map<Long, RegisteredMigrationStep> migrations) {
        return (List)migrations.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getKey)).map(Map.Entry::getValue).collect(MoreCollectors.toList((int)migrations.size()));
    }
}

