/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateAnalysisUuidOnEvents
extends DataChange {
    public PopulateAnalysisUuidOnEvents(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT distinct e.snapshot_id, s.uuid from events e inner join snapshots s on s.id=e.snapshot_id and s.scope = 'PRJ' and s.qualifier in ('TRK', 'DEV', 'VW') where e.snapshot_id is not null and e.analysis_uuid is null");
        massUpdate.update("UPDATE events SET analysis_uuid=? WHERE snapshot_id=? and analysis_uuid is null");
        massUpdate.rowPluralName("analysis uuid of root component events");
        massUpdate.execute(PopulateAnalysisUuidOnEvents::handle);
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        long snapshotId = row.getLong(1);
        String snapshotUuid = row.getString(2);
        update.setString(1, snapshotUuid);
        update.setLong(2, snapshotId);
        return true;
    }
}

