/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateUuidColumnsOfProjects
extends DataChange {
    private static final Logger LOG = Loggers.get(PopulateUuidColumnsOfProjects.class);

    public PopulateUuidColumnsOfProjects(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        Map<Long, String> componentUuidById = PopulateUuidColumnsOfProjects.buildComponentUuidMap(context);
        if (componentUuidById.isEmpty()) {
            return;
        }
        PopulateUuidColumnsOfProjects.populateRootUuidColumnForRoots(context);
        PopulateUuidColumnsOfProjects.populateRootUuidColumnForSubnodes(context, componentUuidById);
        PopulateUuidColumnsOfProjects.populateCopyComponentUuidColumn(context, componentUuidById);
        PopulateUuidColumnsOfProjects.populatePersonUuidColumn(context, componentUuidById);
    }

    private static Map<Long, String> buildComponentUuidMap(DataChange.Context context) throws SQLException {
        HashMap<Long, String> componentUuidById = new HashMap<Long, String>();
        context.prepareSelect("select distinct p1.id, p1.uuid from projects p1 where p1.root_id is null and p1.root_uuid is null").scroll(row -> componentUuidById.put(row.getLong(1), row.getString(2)));
        context.prepareSelect("select distinct p1.id, p1.uuid from projects p1 join projects p2 on p1.id = p2.root_id where p2.root_uuid is null").scroll(row -> componentUuidById.put(row.getLong(1), row.getString(2)));
        context.prepareSelect("select distinct p1.id, p1.uuid from projects p1 join projects p2 on p1.id = p2.copy_resource_id where p2.copy_resource_id is not null and p2.copy_component_uuid is null").scroll(row -> componentUuidById.put(row.getLong(1), row.getString(2)));
        context.prepareSelect("select distinct p1.id, p1.uuid from projects p1 join projects p2 on p1.id = p2.person_id where p2.person_id is not null and p2.developer_uuid is null").scroll(row -> componentUuidById.put(row.getLong(1), row.getString(2)));
        return componentUuidById;
    }

    private static void populateRootUuidColumnForRoots(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT distinct p.id from projects p where p.root_id is null and p.root_uuid is null");
        massUpdate.update("UPDATE projects SET root_uuid=uuid WHERE id=? and root_id is null and root_uuid is null");
        massUpdate.rowPluralName("root uuid of root components");
        massUpdate.execute(PopulateUuidColumnsOfProjects::handleRootIdUpdateForRootNodes);
    }

    private static boolean handleRootIdUpdateForRootNodes(Select.Row row, SqlStatement update) throws SQLException {
        long rootId = row.getLong(1);
        update.setLong(1, rootId);
        return true;
    }

    private static void populateRootUuidColumnForSubnodes(DataChange.Context context, Map<Long, String> componentUuidById) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT distinct p.root_id from projects p where p.root_id is not null and p.root_uuid is null");
        massUpdate.update("UPDATE projects SET root_uuid=? WHERE root_id=? and root_uuid is null");
        massUpdate.rowPluralName("root uuid of non-root components");
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateUuidColumnsOfProjects.handleRootIdUpdateForSubNodes(componentUuidById, row, update));
    }

    private static boolean handleRootIdUpdateForSubNodes(Map<Long, String> componentUuidById, Select.Row row, SqlStatement update) throws SQLException {
        long rootId = row.getLong(1);
        String rootUuid = componentUuidById.get(rootId);
        if (rootUuid == null) {
            LOG.trace("No UUID found for rootId={}", (Object)rootUuid);
            return false;
        }
        update.setString(1, rootUuid);
        update.setLong(2, rootId);
        return true;
    }

    private static void populateCopyComponentUuidColumn(DataChange.Context context, Map<Long, String> componentUuidById) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT p.id, p.copy_resource_id from projects p where p.copy_resource_id is not null and p.copy_component_uuid is null");
        massUpdate.update("UPDATE projects SET copy_component_uuid=? WHERE id=?");
        massUpdate.rowPluralName("copy component uuid of components");
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateUuidColumnsOfProjects.handleCopyComponentUuidUpdate(componentUuidById, row, update));
    }

    private static boolean handleCopyComponentUuidUpdate(Map<Long, String> componentUuidById, Select.Row row, SqlStatement update) throws SQLException {
        long id = row.getLong(1);
        long copyResourceId = row.getLong(2);
        String copyComponentUuid = componentUuidById.get(copyResourceId);
        if (copyComponentUuid == null) {
            LOG.trace("No UUID found for copyResourceId={}", (Object)copyResourceId);
            return false;
        }
        update.setString(1, copyComponentUuid);
        update.setLong(2, id);
        return true;
    }

    private static void populatePersonUuidColumn(DataChange.Context context, Map<Long, String> componentUuidById) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT p.id, p.person_id from projects p where p.person_id is not null and p.developer_uuid is null");
        massUpdate.update("UPDATE projects SET developer_uuid=? WHERE id=?");
        massUpdate.rowPluralName("person uuid of components");
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateUuidColumnsOfProjects.handleDeveloperUuuidUpdate(componentUuidById, row, update));
    }

    private static boolean handleDeveloperUuuidUpdate(Map<Long, String> componentUuidById, Select.Row row, SqlStatement update) throws SQLException {
        long id = row.getLong(1);
        long personId = row.getLong(2);
        String developerUuid = componentUuidById.get(personId);
        if (developerUuid == null) {
            LOG.trace("No UUID found for personId={}", (Object)personId);
            return false;
        }
        update.setString(1, developerUuid);
        update.setLong(2, id);
        return true;
    }
}

