/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateUuidPathColumnOnProjects
extends DataChange {
    private static final Logger LOG = Loggers.get(PopulateUuidPathColumnOnProjects.class);
    private static final Joiner PATH_JOINER = Joiner.on((char)'.');
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'.').omitEmptyStrings();
    private static final String PATH_SEPARATOR = ".";
    private static final String ROOT_PATH = ".";

    public PopulateUuidPathColumnOnProjects(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        List<String> rootComponentUuids = context.prepareSelect("select distinct project_uuid from projects where uuid_path is null").list(row -> row.getString(1));
        for (String rootUuid : rootComponentUuids) {
            PopulateUuidPathColumnOnProjects.handleRoot(rootUuid, context);
        }
        PopulateUuidPathColumnOnProjects.handleOrphans(context);
    }

    private static void handleRoot(String rootComponentUuid, DataChange.Context context) throws SQLException {
        Relations relations = new Relations();
        ((Select)((Select)context.prepareSelect("select s.id, s.path, s.component_uuid from snapshots s where s.root_component_uuid=? and s.islast=?").setString(1, rootComponentUuid)).setBoolean(2, true)).scroll(row -> {
            long snapshotId = row.getLong(1);
            String snapshotPath = row.getString(2);
            String componentUuid = row.getString(3);
            relations.add(new Snapshot(snapshotId, snapshotPath, componentUuid));
        });
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select p.uuid, p.project_uuid from projects p where p.project_uuid=? and p.uuid_path is null").setString(1, rootComponentUuid);
        massUpdate.update("update projects set uuid_path=? where uuid=? and uuid_path is null");
        massUpdate.rowPluralName("components in tree of " + rootComponentUuid);
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateUuidPathColumnOnProjects.handleComponent(relations, row, update));
    }

    private static void handleOrphans(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select uuid, project_uuid from projects where uuid_path is null");
        massUpdate.update("update projects set uuid_path=? where uuid=? and uuid_path is null");
        massUpdate.rowPluralName("orphan components");
        massUpdate.execute((Select.Row row, SqlStatement update, int updateIndex) -> {
            String rootUuid;
            String uuid = row.getString(1);
            String path = uuid.equals(rootUuid = row.getString(2)) ? "." : "." + rootUuid + ".";
            update.setString(1, path);
            update.setString(2, uuid);
            return true;
        });
    }

    private static boolean handleComponent(Relations relations, Select.Row row, SqlStatement update) throws SQLException {
        String rootComponentUuid;
        String componentUuid = row.getString(1);
        if (componentUuid.equals(rootComponentUuid = row.getString(2))) {
            update.setString(1, ".");
            update.setString(2, componentUuid);
            return true;
        }
        Snapshot snapshot = (Snapshot)relations.snapshotsByComponentUuid.get(componentUuid);
        if (snapshot == null) {
            LOG.trace("No UUID found for component UUID={}", (Object)componentUuid);
            return false;
        }
        List componentUuidPath = Arrays.stream(snapshot.snapshotPath).mapToObj(relations.snapshotsById::get).filter(Objects::nonNull).map(s -> ((Snapshot)s).componentUuid).collect(Collectors.toCollection(ArrayList::new));
        if (componentUuidPath.size() != snapshot.snapshotPath.length) {
            LOG.trace("Some component UUIDs not found for snapshots [{}]", (Object)snapshot.snapshotPath);
            return false;
        }
        update.setString(1, "." + PATH_JOINER.join((Iterable)componentUuidPath) + ".");
        update.setString(2, componentUuid);
        return true;
    }

    private static final class Snapshot {
        private static final long[] EMPTY_PATH = new long[0];
        private final long id;
        private final long[] snapshotPath;
        private final String componentUuid;

        public Snapshot(long id, String snapshotPath, String componentUuid) {
            this.id = id;
            this.snapshotPath = Snapshot.parsePath(snapshotPath);
            this.componentUuid = componentUuid;
        }

        private static long[] parsePath(@Nullable String snapshotPath) {
            if (snapshotPath == null) {
                return EMPTY_PATH;
            }
            return PATH_SPLITTER.splitToList((CharSequence)snapshotPath).stream().mapToLong(Long::parseLong).toArray();
        }
    }

    private static final class Relations {
        private final Map<String, Snapshot> snapshotsByComponentUuid = new HashMap<String, Snapshot>();
        private final Map<Long, Snapshot> snapshotsById = new HashMap<Long, Snapshot>();

        private Relations() {
        }

        void add(Snapshot snapshot) {
            this.snapshotsByComponentUuid.put(snapshot.componentUuid, snapshot);
            this.snapshotsById.put(snapshot.id, snapshot);
        }
    }
}

