/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class DeletePersonMeasures
extends DataChange {
    public DeletePersonMeasures(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select uuid from snapshots");
        massUpdate.rowPluralName("snapshots");
        massUpdate.update(this.getDeleteSql()).setBatchSize(1);
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String analysisUuid = row.getString(1);
            update.setString(1, analysisUuid);
            if (this.getDialect().getId().equals("oracle")) {
                update.setString(2, analysisUuid);
            }
            return true;
        });
    }

    private String getDeleteSql() {
        switch (this.getDialect().getId()) {
            case "mysql": 
            case "mssql": {
                return "delete pm from project_measures pm inner join projects c on c.uuid = pm.component_uuid where pm.analysis_uuid = ? and pm.person_id is not null";
            }
            case "h2": {
                return "delete from project_measures where id in (   select pm.id from project_measures pm   inner join projects c on c.uuid = pm.component_uuid   where pm.analysis_uuid = ?   and pm.person_id is not null)";
            }
            case "postgresql": {
                return "delete from project_measures pm using projects c where pm.analysis_uuid = ? and c.uuid = pm.component_uuid and pm.person_id is not null";
            }
            case "oracle": {
                return "delete from project_measures pm where exists (  select 1 from project_measures pm2   inner join projects c on c.uuid = pm2.component_uuid   where pm2.analysis_uuid = ?   and pm.person_id is not null   and pm.id = pm2.id) and pm.analysis_uuid = ?";
            }
        }
        throw new IllegalStateException("Unsupported DB dialect: " + this.getDialect());
    }
}

