/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v74;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.DropColumnsBuilder;
import org.sonar.server.platform.db.migration.sql.DropIndexBuilder;
import org.sonar.server.platform.db.migration.sql.RenameColumnsBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public abstract class FinalizeMainComponentUuidColumnsToCeTable
extends DdlChange {
    private static final VarcharColumnDef COLUMN_COMPONENT_UUID = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("component_uuid").setLimit(40).setIsNullable(true).build();
    private static final VarcharColumnDef COLUMN_MAIN_COMPONENT_UUID = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("main_component_uuid").setLimit(40).setIsNullable(true).build();
    private final String tableName;

    FinalizeMainComponentUuidColumnsToCeTable(Database db, String tableName) {
        super(db);
        this.tableName = tableName;
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(this.tableName).setName(this.tableName + "_component_uuid").build());
        context.execute(new DropColumnsBuilder(this.getDialect(), this.tableName, "component_uuid").build());
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(this.tableName).setName(this.tableName + "_tmp_cpnt_uuid").build());
        context.execute(new DropIndexBuilder(this.getDialect()).setTable(this.tableName).setName(this.tableName + "_tmp_main_cpnt_uuid").build());
        context.execute(new RenameColumnsBuilder(this.getDialect(), this.tableName).renameColumn("tmp_component_uuid", COLUMN_COMPONENT_UUID).renameColumn("tmp_main_component_uuid", COLUMN_MAIN_COMPONENT_UUID).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(this.tableName).setName(this.tableName + "_component").addColumn(COLUMN_COMPONENT_UUID).setUnique(false).build());
        context.execute(new CreateIndexBuilder(this.getDialect()).setTable(this.tableName).setName(this.tableName + "_main_component").addColumn(COLUMN_MAIN_COMPONENT_UUID).setUnique(false).build());
    }
}

