/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v79;

import java.sql.SQLException;
import org.sonar.api.SonarRuntime;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Upsert;

@SupportsBlueGreen
public class PopulateInstallDateAndVersion
extends DataChange {
    private static final Logger LOG = Loggers.get(PopulateInstallDateAndVersion.class);
    private static final String INSTALLATION_DATE = "installation.date";
    private static final String INSTALLATION_VERSION = "installation.version";
    private final SonarRuntime sonarRuntime;
    private final System2 system2;

    public PopulateInstallDateAndVersion(Database db, SonarRuntime sonarRuntime, System2 system2) {
        super(db);
        this.sonarRuntime = sonarRuntime;
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        PopulateInstallDateAndVersion.removeProperties(context);
        Long createdAt = context.prepareSelect("select min(created_at) from users where created_at is not null").get(row -> row.getLong(1));
        if (createdAt != null && createdAt != 0L) {
            this.populateInstallationDate(context, createdAt);
            this.populateInstallationVersion(context, createdAt);
        }
    }

    private void populateInstallationDate(DataChange.Context context, Long createdAt) throws SQLException {
        this.insertInternalProperty(context, INSTALLATION_DATE, String.valueOf(createdAt));
    }

    private void populateInstallationVersion(DataChange.Context context, Long createdAt) throws SQLException {
        if (Math.abs(this.system2.now() - createdAt) / 60L / 60L / 1000L <= 24L) {
            String apiVersion = this.sonarRuntime.getApiVersion().toString();
            this.insertInternalProperty(context, INSTALLATION_VERSION, apiVersion);
        } else {
            LOG.warn("skipping installation.version because we cannot determine what is the installation version.");
        }
    }

    private void insertInternalProperty(DataChange.Context context, String key, String value) throws SQLException {
        ((Upsert)((Upsert)((Upsert)((Upsert)((Upsert)context.prepareUpsert("insert into internal_properties (kee, is_empty, text_value, clob_value, created_at) VALUES (?, ?, ?, ?, ?)").setString(1, key)).setBoolean(2, false)).setString(3, value)).setString(4, null)).setLong(5, this.system2.now())).execute().commit().close();
    }

    private static void removeProperties(DataChange.Context context) throws SQLException {
        ((Upsert)((Upsert)context.prepareUpsert("delete from internal_properties where kee = ? or kee = ?").setString(1, INSTALLATION_DATE)).setString(2, INSTALLATION_VERSION)).execute().commit().close();
    }
}

