/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S107")
public class TooManyParametersCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S107";
    private static final String MESSAGE = "%s has %s parameters, which is greater than the %s authorized.";
    private static final int DEFAULT_MAX = 7;
    @RuleProperty(key="max", defaultValue="7")
    public int max = 7;

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return TooManyParametersCheck.immutableSet(PythonGrammar.FUNCDEF, PythonGrammar.LAMBDEF);
    }

    @Override
    public void visitNode(AstNode node) {
        int nbParameters = node.select().children(PythonGrammar.TYPEDARGSLIST, PythonGrammar.VARARGSLIST).children(PythonGrammar.TFPDEF, PythonGrammar.FPDEF).size();
        if (nbParameters > this.max) {
            String name = "Lambda";
            if (node.is(PythonGrammar.FUNCDEF)) {
                String typeName = CheckUtils.isMethodDefinition(node) ? "Method" : "Function";
                name = node.getFirstChild(PythonGrammar.FUNCNAME).getTokenOriginalValue();
                name = String.format("%s \"%s\"", typeName, name);
            }
            String message = String.format(MESSAGE, name, nbParameters, this.max);
            this.addIssue(node.getFirstChild(PythonGrammar.TYPEDARGSLIST, PythonGrammar.VARARGSLIST), message);
        }
    }
}

