/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.auth.github;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.authentication.Display;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.api.server.authentication.UnauthorizedException;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonarsource.auth.github.GitHubRestClient;
import org.sonarsource.auth.github.GitHubSettings;
import org.sonarsource.auth.github.GsonUser;
import org.sonarsource.auth.github.ScribeGitHubApi;
import org.sonarsource.auth.github.UserIdentityFactory;

@ServerSide
public class GitHubIdentityProvider
implements OAuth2IdentityProvider {
    static final String KEY = "github";
    private final GitHubSettings settings;
    private final UserIdentityFactory userIdentityFactory;
    private final ScribeGitHubApi scribeApi;
    private final GitHubRestClient gitHubRestClient;

    public GitHubIdentityProvider(GitHubSettings settings, UserIdentityFactory userIdentityFactory, ScribeGitHubApi scribeApi, GitHubRestClient gitHubRestClient) {
        this.settings = settings;
        this.userIdentityFactory = userIdentityFactory;
        this.scribeApi = scribeApi;
        this.gitHubRestClient = gitHubRestClient;
    }

    public String getKey() {
        return KEY;
    }

    public String getName() {
        return "GitHub";
    }

    public Display getDisplay() {
        return Display.builder().setIconPath("/static/authgithub/github.svg").setBackgroundColor("#444444").build();
    }

    public boolean isEnabled() {
        return this.settings.isEnabled();
    }

    public boolean allowsUsersToSignUp() {
        return this.settings.allowUsersToSignUp();
    }

    public void init(OAuth2IdentityProvider.InitContext context) {
        String state = context.generateCsrfState();
        OAuth20Service scribe = (OAuth20Service)this.newScribeBuilder((OAuth2IdentityProvider.OAuth2Context)context).scope(this.getScope()).state(state).build((BaseApi)this.scribeApi);
        String url = scribe.getAuthorizationUrl();
        context.redirectTo(url);
    }

    String getScope() {
        return this.settings.syncGroups() || this.isOrganizationMembershipRequired() ? "user:email,read:org" : "user:email";
    }

    public void callback(OAuth2IdentityProvider.CallbackContext context) {
        try {
            this.onCallback(context);
        }
        catch (IOException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    private void onCallback(OAuth2IdentityProvider.CallbackContext context) throws InterruptedException, ExecutionException, IOException {
        context.verifyCsrfState();
        HttpServletRequest request = context.getRequest();
        OAuth20Service scribe = (OAuth20Service)this.newScribeBuilder((OAuth2IdentityProvider.OAuth2Context)context).build((BaseApi)this.scribeApi);
        String code = request.getParameter("code");
        OAuth2AccessToken accessToken = scribe.getAccessToken(code);
        GsonUser user = this.gitHubRestClient.getUser(scribe, accessToken);
        this.check(scribe, accessToken, user);
        String email = user.getEmail() == null ? this.gitHubRestClient.getEmail(scribe, accessToken) : user.getEmail();
        UserIdentity userIdentity = this.userIdentityFactory.create(user, email, this.settings.syncGroups() ? this.gitHubRestClient.getTeams(scribe, accessToken) : null);
        context.authenticate(userIdentity);
        context.redirectToRequestedPage();
    }

    boolean isOrganizationMembershipRequired() {
        return this.settings.organizations().length > 0;
    }

    private void check(OAuth20Service scribe, OAuth2AccessToken accessToken, GsonUser user) throws InterruptedException, ExecutionException, IOException {
        if (this.isUnauthorized(scribe, accessToken, user.getLogin())) {
            throw new UnauthorizedException(String.format("'%s' must be a member of at least one organization: '%s'", user.getLogin(), String.join((CharSequence)"', '", this.settings.organizations())));
        }
    }

    private boolean isUnauthorized(OAuth20Service scribe, OAuth2AccessToken accessToken, String login) throws IOException, ExecutionException, InterruptedException {
        return this.isOrganizationMembershipRequired() && !this.isOrganizationsMember(scribe, accessToken, login);
    }

    private boolean isOrganizationsMember(OAuth20Service scribe, OAuth2AccessToken accessToken, String login) throws IOException, ExecutionException, InterruptedException {
        for (String organization : this.settings.organizations()) {
            if (!this.gitHubRestClient.isOrganizationMember(scribe, accessToken, organization, login)) continue;
            return true;
        }
        return false;
    }

    private ServiceBuilder newScribeBuilder(OAuth2IdentityProvider.OAuth2Context context) {
        if (!this.isEnabled()) {
            throw new IllegalStateException("GitHub authentication is disabled");
        }
        return new ServiceBuilder(this.settings.clientId()).apiSecret(this.settings.clientSecret()).callback(context.getCallbackUrl());
    }
}

