/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

public enum ProcessId {
    APP("app", 0, "sonar"),
    ELASTICSEARCH("es", 1, "es"),
    WEB_SERVER("web", 2, "web"),
    COMPUTE_ENGINE("ce", 3, "ce");

    private final String key;
    private final int ipcIndex;
    private final String logFilenamePrefix;

    private ProcessId(String key, int ipcIndex, String logFilenamePrefix) {
        this.key = key;
        this.ipcIndex = ipcIndex;
        this.logFilenamePrefix = logFilenamePrefix;
    }

    public String getKey() {
        return this.key;
    }

    public int getIpcIndex() {
        return this.ipcIndex;
    }

    public String getLogFilenamePrefix() {
        return this.logFilenamePrefix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append("key='").append(this.key).append('\'');
        sb.append(", ipcIndex=").append(this.ipcIndex);
        sb.append(", logFilenamePrefix=").append(this.logFilenamePrefix);
        sb.append(']');
        return sb.toString();
    }

    public static ProcessId fromKey(String key) {
        for (ProcessId processId : ProcessId.values()) {
            if (!processId.getKey().equals(key)) continue;
            return processId;
        }
        throw new IllegalArgumentException(String.format("Process [%s] does not exist", key));
    }
}

