/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopWatcher
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(StopWatcher.class);
    private final Runnable stopCommand;
    private final BooleanSupplier shouldStopTest;
    private final long delayMs;
    private volatile boolean watching = true;

    public StopWatcher(String threadName, Runnable stopCommand, BooleanSupplier shouldStopTest) {
        this(threadName, stopCommand, shouldStopTest, 500L);
    }

    @VisibleForTesting
    StopWatcher(String threadName, Runnable stopCommand, BooleanSupplier shouldStopTest, long delayMs) {
        super(threadName);
        this.stopCommand = stopCommand;
        this.shouldStopTest = shouldStopTest;
        this.delayMs = delayMs;
    }

    @Override
    public void run() {
        while (this.watching) {
            if (this.shouldStopTest.getAsBoolean()) {
                LOG.trace("{} triggering stop command", (Object)this.getName());
                this.stopCommand.run();
                this.watching = false;
                continue;
            }
            try {
                Thread.sleep(this.delayMs);
            }
            catch (InterruptedException ignored) {
                this.watching = false;
                Thread.currentThread().interrupt();
            }
        }
    }

    public void stopWatching() {
        super.interrupt();
        this.watching = false;
    }
}

