/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.cluster.health;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Startable;
import org.sonar.process.cluster.health.HealthStateRefresherExecutorService;
import org.sonar.process.cluster.health.NodeHealth;
import org.sonar.process.cluster.health.NodeHealthProvider;
import org.sonar.process.cluster.health.SharedHealthState;

public class HealthStateRefresher
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(HealthStateRefresher.class);
    private static final int INITIAL_DELAY = 1;
    private static final int DELAY = 10;
    private final HealthStateRefresherExecutorService executorService;
    private final NodeHealthProvider nodeHealthProvider;
    private final SharedHealthState sharedHealthState;

    public HealthStateRefresher(HealthStateRefresherExecutorService executorService, NodeHealthProvider nodeHealthProvider, SharedHealthState sharedHealthState) {
        this.executorService = executorService;
        this.nodeHealthProvider = nodeHealthProvider;
        this.sharedHealthState = sharedHealthState;
    }

    public void start() {
        this.executorService.scheduleWithFixedDelay(this::refresh, 1L, 10L, TimeUnit.SECONDS);
    }

    private void refresh() {
        try {
            NodeHealth nodeHealth = this.nodeHealthProvider.get();
            this.sharedHealthState.writeMine(nodeHealth);
        }
        catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
            LOG.debug("Hazelcast is no more active", e);
        }
        catch (Throwable t) {
            LOG.error("An error occurred while attempting to refresh HealthState of the current node in the shared state:", t);
        }
    }

    public void stop() {
        this.sharedHealthState.clearMine();
    }
}

