/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.cluster.health;

import com.google.common.base.Preconditions;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;

public class NodeDetails
implements Externalizable {
    private Type type;
    private String name;
    private String host;
    private int port;
    private long startedAt;

    public NodeDetails() {
    }

    private NodeDetails(Builder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.host = builder.host;
        this.port = builder.port;
        this.startedAt = builder.startedAt;
    }

    public static Builder newNodeDetailsBuilder() {
        return new Builder();
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public String toString() {
        return "NodeDetails{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", startedAt=" + this.startedAt + '}';
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type.ordinal());
        out.writeUTF(this.name);
        out.writeUTF(this.host);
        out.writeInt(this.port);
        out.writeLong(this.startedAt);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.type = Type.values()[in.readInt()];
        this.name = in.readUTF();
        this.host = in.readUTF();
        this.port = in.readInt();
        this.startedAt = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeDetails that = (NodeDetails)o;
        return this.port == that.port && this.startedAt == that.startedAt && this.type == that.type && this.name.equals(that.name) && this.host.equals(that.host);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.host, this.port, this.startedAt});
    }

    public static enum Type {
        APPLICATION,
        SEARCH;

    }

    public static class Builder {
        private Type type;
        private String name;
        private String host;
        private int port;
        private long startedAt;

        private Builder() {
        }

        public Builder setType(Type type) {
            this.type = Builder.checkType(type);
            return this;
        }

        public Builder setName(String name) {
            this.name = Builder.checkString(name, "name");
            return this;
        }

        public Builder setHost(String host) {
            this.host = Builder.checkString(host, "host");
            return this;
        }

        public Builder setPort(int port) {
            Builder.checkPort(port);
            this.port = port;
            return this;
        }

        public Builder setStartedAt(long startedAt) {
            Builder.checkStartedAt(startedAt);
            this.startedAt = startedAt;
            return this;
        }

        public NodeDetails build() {
            Builder.checkType(this.type);
            Builder.checkString(this.name, "name");
            Builder.checkString(this.host, "host");
            Builder.checkPort(this.port);
            Builder.checkStartedAt(this.startedAt);
            return new NodeDetails(this);
        }

        private static Type checkType(Type type) {
            return Objects.requireNonNull(type, "type can't be null");
        }

        private static String checkString(String name, String label) {
            Preconditions.checkNotNull((Object)name, (String)"%s can't be null", (Object[])new Object[]{label});
            String value = name.trim();
            Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (String)"%s can't be empty", (Object[])new Object[]{label});
            return value;
        }

        private static void checkPort(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port must be > 0");
        }

        private static void checkStartedAt(long startedAt) {
            Preconditions.checkArgument((startedAt > 0L ? 1 : 0) != 0, (Object)"startedAt must be > 0");
        }
    }
}

