/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.logging;

import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.process.ProcessId;

public final class RootLoggerConfig {
    private final ProcessId processId;
    private final String threadIdFieldPattern;

    private RootLoggerConfig(Builder builder) {
        this.processId = Objects.requireNonNull(builder.processId);
        this.threadIdFieldPattern = builder.threadIdFieldPattern;
    }

    public static Builder newRootLoggerConfigBuilder() {
        return new Builder();
    }

    public ProcessId getProcessId() {
        return this.processId;
    }

    public String getThreadIdFieldPattern() {
        return this.threadIdFieldPattern;
    }

    public static final class Builder {
        @CheckForNull
        private ProcessId processId;
        private String threadIdFieldPattern = "";

        private Builder() {
        }

        public Builder setProcessId(ProcessId processId) {
            this.processId = processId;
            return this;
        }

        public Builder setThreadIdFieldPattern(String threadIdFieldPattern) {
            this.threadIdFieldPattern = Objects.requireNonNull(threadIdFieldPattern, "threadIdFieldPattern can't be null");
            return this;
        }

        public RootLoggerConfig build() {
            return new RootLoggerConfig(this);
        }
    }
}

