/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.scripting;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.ExpressionNode;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="JspScriptletCheck")
public class JspScriptletCheck
extends AbstractPageCheck {
    @Override
    public void expression(ExpressionNode node) {
        String content = JspScriptletCheck.trimScriptlet(node.getCode());
        if (StringUtils.isNotBlank(content)) {
            this.createIssue(node.getStartLinePosition());
        }
    }

    @Override
    public void startElement(TagNode element) {
        if (StringUtils.equalsIgnoreCase(element.getLocalName(), "scriptlet")) {
            this.createIssue(element.getStartLinePosition());
        }
    }

    private static String trimScriptlet(String code) {
        return StringUtils.removeEnd(StringUtils.removeStart(code, "<%"), "%>");
    }

    private void createIssue(int line) {
        this.createViolation(line, "Replace this scriptlet using tag libraries and expression language.");
    }
}

