/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="ServerSideImageMapsCheck")
public class ServerSideImageMapsCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (ServerSideImageMapsCheck.isImgTag(node) && ServerSideImageMapsCheck.hasIsMapAttribute(node)) {
            this.createViolation(node, "Use the \"map\" tag and \"area\" tags instead.");
        }
    }

    private static boolean isImgTag(TagNode node) {
        return "IMG".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasIsMapAttribute(TagNode node) {
        return node.getAttribute("ISMAP") != null;
    }
}

