/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.dns.DNSKerberosLocator;
import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;

abstract class SSPIAuthentication {
    private static final Pattern SPN_PATTERN = Pattern.compile("MSSQLSvc/(.*):([^:@]+)(@.+)?", 2);
    private RealmValidator validator;

    SSPIAuthentication() {
    }

    abstract byte[] generateClientContext(byte[] var1, boolean[] var2) throws SQLServerException;

    abstract void releaseClientContext();

    private String makeSpn(SQLServerConnection con, String server, int port) {
        StringBuilder spn = new StringBuilder("MSSQLSvc/");
        if (con.serverNameAsACE()) {
            spn.append(IDN.toASCII(server));
        } else {
            spn.append(server);
        }
        spn.append(":");
        spn.append(port);
        return spn.toString();
    }

    private RealmValidator getRealmValidator() {
        if (null != this.validator) {
            return this.validator;
        }
        this.validator = new RealmValidator(){

            @Override
            public boolean isRealmValid(String realm) {
                try {
                    return DNSKerberosLocator.isRealmValid(realm);
                }
                catch (NamingException err) {
                    return false;
                }
            }
        };
        return this.validator;
    }

    private String findRealmFromHostname(RealmValidator realmValidator, String hostname) {
        if (hostname == null) {
            return null;
        }
        int index = 0;
        while (index != -1 && index < hostname.length() - 2) {
            String realm = hostname.substring(index);
            if (realmValidator.isRealmValid(realm)) {
                return realm.toUpperCase();
            }
            if (-1 == (index = hostname.indexOf(".", index + 1))) continue;
            ++index;
        }
        return null;
    }

    String enrichSpnWithRealm(String spn, boolean allowHostnameCanonicalization) {
        if (spn == null) {
            return spn;
        }
        Matcher m = SPN_PATTERN.matcher(spn);
        if (!m.matches()) {
            return spn;
        }
        if (m.group(3) != null) {
            return spn;
        }
        String dnsName = m.group(1);
        String portOrInstance = m.group(2);
        RealmValidator realmValidator = this.getRealmValidator();
        String realm = this.findRealmFromHostname(realmValidator, dnsName);
        if (realm == null && allowHostnameCanonicalization) {
            try {
                String canonicalHostName = InetAddress.getByName(dnsName).getCanonicalHostName();
                realm = this.findRealmFromHostname(realmValidator, canonicalHostName);
                dnsName = canonicalHostName;
            }
            catch (UnknownHostException canonicalHostName) {
                // empty catch block
            }
        }
        if (realm == null) {
            return spn;
        }
        StringBuilder sb = new StringBuilder("MSSQLSvc/");
        sb.append(dnsName).append(":").append(portOrInstance).append("@").append(realm.toUpperCase(Locale.ENGLISH));
        return sb.toString();
    }

    String getSpn(SQLServerConnection con) {
        Object spn;
        if (null == con || null == con.activeConnectionProperties) {
            return null;
        }
        String userSuppliedServerSpn = con.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.SERVER_SPN.toString());
        if (null != userSuppliedServerSpn) {
            if (con.serverNameAsACE()) {
                int slashPos = userSuppliedServerSpn.indexOf("/");
                spn = userSuppliedServerSpn.substring(0, slashPos + 1) + IDN.toASCII(userSuppliedServerSpn.substring(slashPos + 1));
            } else {
                spn = userSuppliedServerSpn;
            }
        } else {
            spn = this.makeSpn(con, con.currentConnectPlaceHolder.getServerName(), con.currentConnectPlaceHolder.getPortNumber());
        }
        return this.enrichSpnWithRealm((String)spn, null == userSuppliedServerSpn);
    }

    static interface RealmValidator {
        public boolean isRealmValid(String var1);
    }
}

